/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.protocol.AbstractExporter;
import com.alibaba.dubbo.rpc.protocol.AbstractInvoker;
import com.alibaba.dubbo.rpc.protocol.AbstractProtocol;
import com.frameworkx.annotation.Adaptive;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.ProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyProtocol
extends AbstractProtocol {
    private static final Logger log = LoggerFactory.getLogger(AbstractProxyProtocol.class);
    private final List<Class<?>> JahhanExceptionList = new CopyOnWriteArrayList();
    @Inject
    @Adaptive
    private ProxyFactory proxyFactory;

    public AbstractProxyProtocol() {
    }

    public AbstractProxyProtocol(Class<?> ... exceptions) {
        for (Class<?> exception : exceptions) {
            this.addJahhanException(exception);
        }
    }

    public void addJahhanException(Class<?> exception) {
        this.JahhanExceptionList.add(exception);
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws JahhanException {
        final String uri = AbstractProxyProtocol.serviceKey(invoker.getUrl());
        Exporter exporter = (Exporter)this.exporterMap.get(uri);
        if (exporter != null) {
            return exporter;
        }
        final Runnable runnable = this.doExport(this.proxyFactory.getProxy(invoker), invoker.getInterface(), invoker.getUrl());
        exporter = new AbstractExporter<T>(invoker){

            @Override
            public void unexport() {
                super.unexport();
                AbstractProxyProtocol.this.exporterMap.remove(uri);
                if (runnable != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        log.warn(t.getMessage(), t);
                    }
                }
            }
        };
        this.exporterMap.put(uri, exporter);
        return exporter;
    }

    @Override
    public <T> Invoker<T> refer(final Class<T> type, final URL url) throws JahhanException {
        final Invoker<T> tagert = this.proxyFactory.getInvoker(this.doRefer(type, url), type, url);
        AbstractInvoker invoker = new AbstractInvoker<T>(type, url){

            @Override
            protected Result doInvoke(Invocation invocation) throws Throwable {
                try {
                    Result result = tagert.invoke(invocation);
                    Throwable e = result.getException();
                    if (e != null) {
                        for (Class JahhanException2 : AbstractProxyProtocol.this.JahhanExceptionList) {
                            if (!JahhanException2.isAssignableFrom(e.getClass())) continue;
                            throw AbstractProxyProtocol.this.getJahhanException(type, url, invocation, e);
                        }
                    }
                    return result;
                }
                catch (JahhanException e) {
                    if (e.getCode() == 999) {
                        e.setCode(AbstractProxyProtocol.this.getErrorCode(e.getCause()));
                    }
                    throw e;
                }
                catch (Throwable e) {
                    throw AbstractProxyProtocol.this.getJahhanException(type, url, invocation, e);
                }
            }
        };
        this.invokers.add(invoker);
        return invoker;
    }

    protected JahhanException getJahhanException(Class<?> type, URL url, Invocation invocation, Throwable e) {
        JahhanException re = new JahhanException("Failed to invoke remote service: " + type + ", method: " + invocation.getMethodName() + ", cause: " + e.getMessage(), e);
        re.setCode(this.getErrorCode(e));
        return re;
    }

    protected int getErrorCode(Throwable e) {
        return 999;
    }

    protected abstract <T> Runnable doExport(T var1, Class<T> var2, URL var3) throws JahhanException;

    protected abstract <T> T doRefer(Class<T> var1, URL var2) throws JahhanException;
}

