/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol;

import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporter<T>
implements Exporter<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractExporter.class);
    private final Invoker<T> invoker;
    private volatile boolean unexported = false;

    public AbstractExporter(Invoker<T> invoker) {
        if (invoker == null) {
            throw new IllegalStateException("service invoker == null");
        }
        if (invoker.getInterface() == null) {
            throw new IllegalStateException("service type == null");
        }
        if (invoker.getUrl() == null) {
            throw new IllegalStateException("service url == null");
        }
        this.invoker = invoker;
    }

    @Override
    public Invoker<T> getInvoker() {
        return this.invoker;
    }

    @Override
    public void unexport() {
        if (this.unexported) {
            return;
        }
        this.unexported = true;
        this.getInvoker().destroy();
    }

    public String toString() {
        return this.getInvoker().toString();
    }
}

