/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.support;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.cluster.Directory;
import com.alibaba.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import java.util.List;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.LoadBalance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger log = LoggerFactory.getLogger(BroadcastClusterInvoker.class);

    public BroadcastClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws JahhanException {
        this.checkInvokers(invokers, invocation);
        RpcContext.getContext().setInvokers(invokers);
        JahhanException exception = null;
        Result result = null;
        for (Invoker<?> invoker : invokers) {
            try {
                result = invoker.invoke(invocation);
            }
            catch (JahhanException e) {
                exception = e;
                log.warn(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                exception = new JahhanException(e.getMessage(), e);
                log.warn(e.getMessage(), e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }
}

