/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.support;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.cluster.Directory;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import com.frameworkx.annotation.DubboInterface;
import com.frameworkx.cache.ClusterMessageHolder;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import com.frameworkx.constant.enumeration.RPCTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jahhan.context.BaseContext;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.LoadBalance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterInvoker<T>
implements Invoker<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractClusterInvoker.class);
    protected final Directory<T> directory;
    protected final boolean availablecheck;
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private volatile Invoker<T> stickyInvoker = null;

    public AbstractClusterInvoker(Directory<T> directory) {
        this(directory, directory.getUrl());
    }

    public AbstractClusterInvoker(Directory<T> directory, URL url) {
        if (directory == null) {
            throw new IllegalArgumentException("service directory == null");
        }
        this.directory = directory;
        this.availablecheck = url.getParameter("cluster.availablecheck", true);
    }

    @Override
    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    @Override
    public URL getUrl() {
        return this.directory.getUrl();
    }

    @Override
    public boolean isAvailable() {
        Invoker<T> invoker = this.stickyInvoker;
        if (invoker != null) {
            return invoker.isAvailable();
        }
        return this.directory.isAvailable();
    }

    @Override
    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.directory.destroy();
        }
    }

    protected Invoker<T> select(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected) throws JahhanException {
        if (invokers == null || invokers.size() == 0) {
            return null;
        }
        String methodName = invocation == null ? "" : invocation.getMethodName();
        boolean sticky = invokers.get(0).getUrl().getMethodParameter(methodName, "sticky", false);
        if (this.stickyInvoker != null && !invokers.contains(this.stickyInvoker)) {
            this.stickyInvoker = null;
        }
        if (sticky && this.stickyInvoker != null && (selected == null || !selected.contains(this.stickyInvoker)) && this.availablecheck && this.stickyInvoker.isAvailable()) {
            return this.stickyInvoker;
        }
        Invoker<T> invoker = this.doselect(loadbalance, invocation, invokers, selected);
        if (sticky) {
            this.stickyInvoker = invoker;
        }
        return invoker;
    }

    private Invoker<T> doselect(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected) throws JahhanException {
        if (invokers == null || invokers.size() == 0) {
            return null;
        }
        if (invokers.size() == 1) {
            return invokers.get(0);
        }
        if (invokers.size() == 2 && selected != null && selected.size() > 0) {
            return selected.get(0) == invokers.get(0) ? invokers.get(1) : invokers.get(0);
        }
        Invoker<T> invoker = loadbalance.select(invokers, this.getUrl(), invocation);
        if (selected != null && selected.contains(invoker) || !invoker.isAvailable() && this.getUrl() != null && this.availablecheck) {
            try {
                Invoker<T> rinvoker = this.reselect(loadbalance, invocation, invokers, selected, this.availablecheck);
                if (rinvoker != null) {
                    invoker = rinvoker;
                } else {
                    int index = invokers.indexOf(invoker);
                    try {
                        invoker = index < invokers.size() - 1 ? invokers.get(index + 1) : invoker;
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage() + " may because invokers list dynamic change, ignore.", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                log.error("clustor relselect fail reason is :" + t.getMessage() + " if can not slove ,you can set cluster.availablecheck=false in url", t);
            }
        }
        return invoker;
    }

    private Invoker<T> reselect(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected, boolean availablecheck) throws JahhanException {
        ArrayList reselectInvokers = new ArrayList(invokers.size() > 1 ? invokers.size() - 1 : invokers.size());
        if (availablecheck) {
            for (Invoker<T> invoker : invokers) {
                if (!invoker.isAvailable() || selected != null && selected.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
            if (reselectInvokers.size() > 0) {
                return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
            }
        } else {
            for (Invoker<T> invoker : invokers) {
                if (selected != null && selected.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
            if (reselectInvokers.size() > 0) {
                return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
            }
        }
        if (selected != null) {
            for (Invoker<T> invoker : selected) {
                if (!invoker.isAvailable() || reselectInvokers.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
        }
        if (reselectInvokers.size() > 0) {
            return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
        }
        return null;
    }

    @Override
    public Result invoke(Invocation invocation) throws JahhanException {
        this.checkWheatherDestoyed();
        List<Invoker<T>> invokers = this.list(invocation);
        invokers = this.direct(invokers, invocation);
        LoadBalance loadbalance = invokers != null && invokers.size() > 0 ? ExtensionExtendUtil.getExtension(LoadBalance.class, invokers.get(0).getUrl().getMethodParameter(invocation.getMethodName(), "loadbalance", "random")) : ExtensionExtendUtil.getExtension(LoadBalance.class, "random");
        RpcUtils.attachInvocationIdIfAsync(this.getUrl(), invocation);
        return this.doInvoke(invocation, invokers, loadbalance);
    }

    private List<Invoker<T>> direct(List<Invoker<T>> invokers, Invocation invocation) throws JahhanException {
        ArrayList<Invoker<T>> filterInvokers = new ArrayList<Invoker<T>>();
        ClusterMessageHolder instance = (ClusterMessageHolder)BaseContext.CTX.getInjector().getInstance(ClusterMessageHolder.class);
        Class<T> invokeInterface = invokers.get(0).getInterface();
        DubboInterface dubboInterface = invokeInterface.getAnnotation(DubboInterface.class);
        if (null != dubboInterface && dubboInterface.rpcType().equals((Object)RPCTypeEnum.DIRECT)) {
            if (invocation.getParameterTypes()[0].equals(String.class)) {
                Map<String, String> map;
                String hosts;
                String target = (String)invocation.getArguments()[0];
                if (null != target && null != (hosts = (map = instance.getServiceMap().get(target)).get(target))) {
                    String[] hostArray;
                    for (String urlString : hostArray = hosts.split(",")) {
                        URL url = URL.valueOf(urlString);
                        for (Invoker<T> invoker : invokers) {
                            URL invokerUrl = invoker.getUrl();
                            String uri = invokerUrl.getHost() + ":" + invokerUrl.getPort();
                            if (!url.getHost().equals(invokerUrl.getHost()) || url.getPort() != invokerUrl.getPort()) continue;
                            log.debug("\u76f4\u63a5\u63a8\u9001\uff1a" + uri);
                            RpcContext.getContext().setAttachment("direct", BaseContext.CTX.getNode().getNodeId());
                            filterInvokers.add(invoker);
                            invocation.getArguments()[0] = BaseContext.CTX.getNode().getNodeId();
                            return filterInvokers;
                        }
                    }
                }
                throw new JahhanException(999, "Failed to invoke the method " + invocation.getMethodName() + " in the service " + this.getInterface().getName() + ". unkown host:" + target + " or target application stop! ");
            }
            throw new JahhanException(999, "error argument,need host target!!");
        }
        return invokers;
    }

    protected void checkWheatherDestoyed() {
        if (this.destroyed.get()) {
            throw new JahhanException("Rpc cluster invoker for " + this.getInterface() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + " is now destroyed! Can not invoke any more.");
        }
    }

    public String toString() {
        return this.getInterface() + " -> " + this.getUrl().toString();
    }

    protected void checkInvokers(List<Invoker<T>> invokers, Invocation invocation) {
        if (invokers == null || invokers.size() == 0) {
            throw new JahhanException("Failed to invoke the method " + invocation.getMethodName() + " in the service " + this.getInterface().getName() + ". No provider available for the service " + this.directory.getUrl().getServiceKey() + " from registry " + this.directory.getUrl().getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ". Please check if the providers have been started and registered.");
        }
    }

    protected abstract Result doInvoke(Invocation var1, List<Invoker<T>> var2, LoadBalance var3) throws JahhanException;

    protected List<Invoker<T>> list(Invocation invocation) throws JahhanException {
        List<Invoker<T>> invokers = this.directory.list(invocation);
        return invokers;
    }
}

