/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.directory;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.cluster.Directory;
import com.alibaba.dubbo.rpc.cluster.Router;
import com.alibaba.dubbo.rpc.cluster.router.MockInvokersSelector;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.RouterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDirectory<T>
implements Directory<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDirectory.class);
    private final URL url;
    private volatile boolean destroyed = false;
    private volatile URL consumerUrl;
    private volatile List<Router> routers;

    public AbstractDirectory(URL url) {
        this(url, null);
    }

    public AbstractDirectory(URL url, List<Router> routers) {
        this(url, url, routers);
    }

    public AbstractDirectory(URL url, URL consumerUrl, List<Router> routers) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url;
        this.consumerUrl = consumerUrl;
        this.setRouters(routers);
    }

    @Override
    public List<Invoker<T>> list(Invocation invocation) throws JahhanException {
        if (this.destroyed) {
            throw new JahhanException("Directory already destroyed .url: " + this.getUrl());
        }
        List<Invoker<T>> invokers = this.doList(invocation);
        List<Router> localRouters = this.routers;
        if (localRouters != null && localRouters.size() > 0) {
            for (Router router : localRouters) {
                try {
                    if (router.getUrl() != null && !router.getUrl().getParameter("runtime", true)) continue;
                    invokers = router.route(invokers, this.getConsumerUrl(), invocation);
                }
                catch (Throwable t) {
                    log.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
                }
            }
        }
        return invokers;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public List<Router> getRouters() {
        return this.routers;
    }

    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    protected void setRouters(List<Router> routers) {
        routers = routers == null ? new ArrayList<Router>() : new ArrayList<Router>(routers);
        String routerkey = this.url.getParameter("router");
        if (routerkey != null && routerkey.length() > 0) {
            RouterFactory routerFactory = ExtensionExtendUtil.getExtension(RouterFactory.class, routerkey);
            routers.add(routerFactory.getRouter(this.url));
        }
        routers.add(new MockInvokersSelector());
        Collections.sort(routers);
        this.routers = routers;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
    }

    protected abstract List<Invoker<T>> doList(Invocation var1) throws JahhanException;
}

