/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.dispatcher;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.transport.ChannelHandlerDelegate;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.jahhan.spi.ChannelHandler;
import net.jahhan.spi.DataStore;
import net.jahhan.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedChannelHandler
implements ChannelHandlerDelegate {
    private static final Logger log = LoggerFactory.getLogger(WrappedChannelHandler.class);
    protected static final ExecutorService SHARED_EXECUTOR = Executors.newCachedThreadPool(new NamedThreadFactory("DubboSharedHandler", true));
    protected final ExecutorService executor;
    protected final ChannelHandler handler;
    protected final URL url;

    public WrappedChannelHandler(ChannelHandler handler, URL url) {
        this.handler = handler;
        this.url = url;
        this.executor = (ExecutorService)ExtensionExtendUtil.getAdaptiveExtension(ThreadPool.class).getExecutor(url);
        String componentKey = Constants.EXECUTOR_SERVICE_COMPONENT_KEY;
        if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
            componentKey = "consumer";
        }
        DataStore dataStore = ExtensionExtendUtil.getExtension(DataStore.class);
        dataStore.put(componentKey, Integer.toString(url.getPort()), this.executor);
    }

    public void close() {
        try {
            if (this.executor instanceof ExecutorService) {
                this.executor.shutdown();
            }
        }
        catch (Throwable t) {
            log.warn("fail to destroy thread pool of server: " + t.getMessage(), t);
        }
    }

    @Override
    public void connected(Channel channel) throws RemotingException {
        this.handler.connected(channel);
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        this.handler.disconnected(channel);
    }

    @Override
    public void sent(Channel channel, Object message) throws RemotingException {
        this.handler.sent(channel, message);
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        this.handler.received(channel, message);
    }

    @Override
    public void caught(Channel channel, Throwable exception) throws RemotingException {
        this.handler.caught(channel, exception);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public ChannelHandler getHandler() {
        if (this.handler instanceof ChannelHandlerDelegate) {
            return ((ChannelHandlerDelegate)this.handler).getHandler();
        }
        return this.handler;
    }

    public URL getUrl() {
        return this.url;
    }
}

