/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.codec;

import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.buffer.ChannelBuffer;
import java.io.IOException;
import net.jahhan.com.alibaba.dubbo.common.io.UnsafeByteArrayInputStream;
import net.jahhan.com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import net.jahhan.common.extension.utils.Assert;
import net.jahhan.spi.Codec;
import net.jahhan.spi.Codec2;

public class CodecAdapter
implements Codec2 {
    private Codec codec;

    public CodecAdapter(Codec codec) {
        Assert.notNull(codec, "codec == null", 999);
        this.codec = codec;
    }

    @Override
    public void encode(Channel channel, ChannelBuffer buffer, Object message) throws IOException {
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream(1024);
        this.codec.encode(channel, os, message);
        buffer.writeBytes(os.toByteArray());
    }

    @Override
    public Object decode(Channel channel, ChannelBuffer buffer) throws IOException {
        byte[] bytes = new byte[buffer.readableBytes()];
        int savedReaderIndex = buffer.readerIndex();
        buffer.readBytes(bytes);
        UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(bytes);
        Object result = this.codec.decode(channel, is);
        buffer.readerIndex(savedReaderIndex + is.position());
        return result == Codec.NEED_MORE_INPUT ? Codec2.DecodeResult.NEED_MORE_INPUT : result;
    }

    public Codec getCodec() {
        return this.codec;
    }
}

