/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport;

import com.alibaba.dubbo.common.URL;
import com.frameworkx.common.extension.utils.ExtensionExtendUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jahhan.spi.Serialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecSupport {
    private static final Logger log = LoggerFactory.getLogger(CodecSupport.class);
    private static Map<Byte, Serialization> ID_SERIALIZATION_MAP = new HashMap<Byte, Serialization>();

    private CodecSupport() {
    }

    public static Serialization getSerializationById(Byte id) {
        return ID_SERIALIZATION_MAP.get(id);
    }

    public static Serialization getSerialization(URL url) {
        return ExtensionExtendUtil.getExtension(Serialization.class, url.getParameter("serialization", "hessian2"));
    }

    public static Serialization getSerialization(URL url, Byte id) {
        Serialization result = CodecSupport.getSerializationById(id);
        if (result == null) {
            result = CodecSupport.getSerialization(url);
        }
        return result;
    }

    static {
        Set<String> supportedExtensions = ExtensionExtendUtil.getSupportedExtensions(Serialization.class);
        for (String name : supportedExtensions) {
            Serialization serialization = ExtensionExtendUtil.getExtension(Serialization.class, name);
            byte idByte = serialization.getContentTypeId();
            if (ID_SERIALIZATION_MAP.containsKey(idByte)) {
                log.error("Serialization extension " + serialization.getClass().getName() + " has duplicate id to Serialization extension " + ID_SERIALIZATION_MAP.get(idByte).getClass().getName() + ", ignore this Serialization extension");
                continue;
            }
            ID_SERIALIZATION_MAP.put(idByte, serialization);
        }
    }
}

