/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.http.tomcat;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.http.HttpHandler;
import com.alibaba.dubbo.remoting.http.support.AbstractHttpServer;
import java.io.File;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import net.jahhan.common.extension.utils.ClassScaner;
import net.jahhan.common.extension.utils.PackageUtil;
import net.jahhan.context.Node;
import net.jahhan.servlet.DispatcherServlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatHttpServer
extends AbstractHttpServer {
    private static final Logger log = LoggerFactory.getLogger(TomcatHttpServer.class);
    private final Tomcat tomcat;
    private final URL url;

    public TomcatHttpServer(URL url, HttpHandler handler) {
        super(url, handler);
        int i;
        String[] urlPatterns;
        this.url = url;
        DispatcherServlet.addHttpHandler(url.getPort(), handler);
        String baseDir = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        this.tomcat = new Tomcat();
        this.tomcat.setBaseDir(baseDir);
        this.tomcat.setPort(url.getPort());
        this.tomcat.getConnector().setProperty("maxThreads", String.valueOf(url.getParameter("threads", 200)));
        this.tomcat.getConnector().setProperty("maxConnections", String.valueOf(url.getParameter("accepts", -1)));
        this.tomcat.getConnector().setProperty("URIEncoding", "UTF-8");
        this.tomcat.getConnector().setProperty("connectionTimeout", "60000");
        this.tomcat.getConnector().setProperty("maxKeepAliveRequests", "-1");
        Context context = this.tomcat.addContext("", baseDir);
        AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
        aprLifecycleListener.setSSLEngine("on");
        this.tomcat.getServer().addLifecycleListener((LifecycleListener)aprLifecycleListener);
        context.addLifecycleListener((LifecycleListener)aprLifecycleListener);
        if (AprLifecycleListener.isAprAvailable()) {
            this.tomcat.getConnector().setProtocol("org.apache.coyote.http11.Http11AprProtocol");
        } else {
            this.tomcat.getConnector().setProtocol("org.apache.coyote.http11.Http11NioProtocol");
        }
        String[] listenerPackages = PackageUtil.packages("listener");
        List<String> listenerClassNameList = new ClassScaner().parse(listenerPackages);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String className : listenerClassNameList) {
            try {
                Class<?> scanClass = classLoader.loadClass(className);
                if (!scanClass.isAnnotationPresent(WebListener.class) || !ServletContextListener.class.isAssignableFrom(scanClass)) continue;
                context.addApplicationListener(className);
            }
            catch (Exception scanClass) {}
        }
        String[] filterPackages = PackageUtil.packages("filter");
        List<String> filterClassNameList = new ClassScaner().parse(filterPackages);
        for (String className : filterClassNameList) {
            try {
                Class<?> scanClass = classLoader.loadClass(className);
                if (!scanClass.isAnnotationPresent(WebFilter.class) || !Filter.class.isAssignableFrom(scanClass)) continue;
                WebFilter webFilter = scanClass.getAnnotation(WebFilter.class);
                FilterDef filterDef = new FilterDef();
                filterDef.setFilter((Filter)scanClass.newInstance());
                filterDef.setFilterName(webFilter.filterName());
                WebInitParam[] initParams = webFilter.initParams();
                for (int i2 = 0; i2 < initParams.length; ++i2) {
                    filterDef.addInitParameter(initParams[i2].name(), initParams[i2].value());
                }
                context.addFilterDef(filterDef);
                FilterMap filterMap = new FilterMap();
                filterMap.setFilterName(webFilter.filterName());
                urlPatterns = webFilter.urlPatterns();
                for (i = 0; i < urlPatterns.length; ++i) {
                    filterMap.addURLPattern(urlPatterns[i]);
                }
                context.addFilterMap(filterMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String[] packages = PackageUtil.packages("servlet");
        List<String> classNameList = new ClassScaner().parse(packages);
        for (String className : classNameList) {
            try {
                Class<?> scanClass = classLoader.loadClass(className);
                if (!scanClass.isAnnotationPresent(WebServlet.class) || !HttpServlet.class.isAssignableFrom(scanClass)) continue;
                WebServlet webServlet = scanClass.getAnnotation(WebServlet.class);
                String name = webServlet.name();
                Tomcat.addServlet((Context)context, (String)name, (Servlet)((HttpServlet)scanClass.newInstance()));
                urlPatterns = webServlet.urlPatterns();
                for (i = 0; i < urlPatterns.length; ++i) {
                    context.addServletMappingDecoded(urlPatterns[i], name);
                }
            }
            catch (ClassNotFoundException scanClass) {
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Node.getInstance().addServletContext(url.getPort(), context.getServletContext());
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new IllegalStateException("Failed to start tomcat server at " + url.getAddress(), e);
        }
    }

    @Override
    public void close() {
        super.close();
        Node.getInstance().removeServletContext(this.url.getPort());
        try {
            this.tomcat.stop();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }
}

