/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.http.jetty;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.http.HttpHandler;
import com.alibaba.dubbo.remoting.http.support.AbstractHttpServer;
import javax.servlet.ServletContext;
import net.jahhan.context.Node;
import net.jahhan.servlet.DispatcherServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.log.StdErrLog;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpServer
extends AbstractHttpServer {
    private static final Logger log = LoggerFactory.getLogger(JettyHttpServer.class);
    private Server server;
    private URL url;

    public JettyHttpServer(URL url, HttpHandler handler) {
        super(url, handler);
        this.url = url;
        Log.setLog((org.mortbay.log.Logger)new StdErrLog());
        Log.getLog().setDebugEnabled(false);
        DispatcherServlet.addHttpHandler(url.getPort(), handler);
        int threads = url.getParameter("threads", 200);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        threadPool.setMaxThreads(threads);
        threadPool.setMinThreads(threads);
        SelectChannelConnector connector = new SelectChannelConnector();
        if (!url.isAnyHost() && NetUtils.isValidLocalHost(url.getHost())) {
            connector.setHost(url.getHost());
        }
        connector.setPort(url.getPort());
        this.server = new Server();
        this.server.setThreadPool((ThreadPool)threadPool);
        this.server.addConnector((Connector)connector);
        ServletHandler servletHandler = new ServletHandler();
        ServletHolder servletHolder = servletHandler.addServletWithMapping(DispatcherServlet.class, "/*");
        servletHolder.setInitOrder(2);
        Context context = new Context((HandlerContainer)this.server, "/", 1);
        context.setServletHandler(servletHandler);
        Node.getInstance().addServletContext(url.getPort(), (ServletContext)context.getServletContext());
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start jetty server on " + url.getAddress() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        super.close();
        Node.getInstance().removeServletContext(this.url.getPort());
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

