/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jahhan.com.alibaba.dubbo.common.utils.ClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);
    private static Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\s*\\{?\\s*([\\._0-9a-zA-Z]+)\\s*\\}?");
    private static volatile Properties PROPERTIES;

    public static boolean isNotEmpty(String value) {
        return !ConfigUtils.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0 || "false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value) || "null".equalsIgnoreCase(value) || "N/A".equalsIgnoreCase(value);
    }

    public static boolean isDefault(String value) {
        return "true".equalsIgnoreCase(value) || "default".equalsIgnoreCase(value);
    }

    public static String replaceProperty(String expression, Map<String, String> params) {
        if (expression == null || expression.length() == 0 || expression.indexOf(36) < 0) {
            return expression;
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = System.getProperty(key);
            if (value == null && params != null) {
                value = params.get(key);
            }
            if (value == null) {
                value = "";
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getProperties() {
        if (PROPERTIES != null) return PROPERTIES;
        Class<ConfigUtils> clazz = ConfigUtils.class;
        synchronized (ConfigUtils.class) {
            if (PROPERTIES != null) return PROPERTIES;
            String path = System.getProperty("dubbo.properties.file");
            if (!(path != null && path.length() != 0 || (path = System.getenv("dubbo.properties.file")) != null && path.length() != 0)) {
                path = "dubbo.properties";
            }
            PROPERTIES = ConfigUtils.loadProperties(path, false, true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return PROPERTIES;
        }
    }

    public static void addProperties(Properties properties) {
        if (properties != null) {
            ConfigUtils.getProperties().putAll((Map<?, ?>)properties);
        }
    }

    public static void setProperties(Properties properties) {
        if (properties != null) {
            PROPERTIES = properties;
        }
    }

    public static String getProperty(String key) {
        return ConfigUtils.getProperty(key, null);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null && value.length() > 0) {
            return value;
        }
        Properties properties = ConfigUtils.getProperties();
        return ConfigUtils.replaceProperty(properties.getProperty(key, defaultValue), properties);
    }

    public static Properties loadProperties(String fileName) {
        return ConfigUtils.loadProperties(fileName, false, false);
    }

    public static Properties loadProperties(String fileName, boolean allowMultiFile) {
        return ConfigUtils.loadProperties(fileName, allowMultiFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String fileName, boolean allowMultiFile, boolean optional) {
        Properties properties = new Properties();
        if (fileName.startsWith("/")) {
            try (FileInputStream input = new FileInputStream(fileName);){
                properties.load(input);
            }
            catch (Throwable e) {
                log.warn("Failed to load " + fileName + " file from " + fileName + "(ingore this file): " + e.getMessage(), e);
            }
            return properties;
        }
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = ClassHelper.getClassLoader().getResources(fileName);
            list = new ArrayList();
            while (urls.hasMoreElements()) {
                list.add(urls.nextElement());
            }
        }
        catch (Throwable t) {
            log.warn("Fail to load " + fileName + " file: " + t.getMessage(), t);
        }
        if (list.size() == 0) {
            if (!optional) {
                log.warn("No " + fileName + " found on the class path.");
            }
            return properties;
        }
        if (!allowMultiFile) {
            if (list.size() > 1) {
                String errMsg = String.format("only 1 %s file is expected, but %d dubbo.properties files found on class path: %s", fileName, list.size(), ((Object)list).toString());
                log.warn(errMsg);
            }
            try {
                properties.load(ClassHelper.getClassLoader().getResourceAsStream(fileName));
            }
            catch (Throwable e) {
                log.warn("Failed to load " + fileName + " file from " + fileName + "(ingore this file): " + e.getMessage(), e);
            }
            return properties;
        }
        log.info("load " + fileName + " properties file from " + list);
        for (URL url : list) {
            try {
                Properties p = new Properties();
                InputStream input = url.openStream();
                if (input == null) continue;
                try {
                    p.load(input);
                    properties.putAll((Map<?, ?>)p);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                log.warn("Fail to load " + fileName + " file from " + url + "(ingore this file): " + e.getMessage(), e);
            }
        }
        return properties;
    }

    private ConfigUtils() {
    }
}

