/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.statusChecker;

import com.alibaba.dubbo.registry.Registry;
import com.alibaba.dubbo.registry.support.AbstractRegistryFactory;
import com.frameworkx.annotation.Activate;
import java.util.Collection;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.extension.statusChecker.Status;
import net.jahhan.spi.StatusChecker;

@Activate
@Extension(value="registry")
@Singleton
public class RegistryStatusChecker
implements StatusChecker {
    public Status check() {
        Collection<Registry> regsitries = AbstractRegistryFactory.getRegistries();
        if (regsitries == null || regsitries.size() == 0) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = Status.Level.OK;
        StringBuilder buf = new StringBuilder();
        for (Registry registry : regsitries) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(registry.getUrl().getAddress());
            if (!registry.isAvailable()) {
                level = Status.Level.ERROR;
                buf.append("(disconnected)");
                continue;
            }
            buf.append("(connected)");
        }
        return new Status(level, buf.toString());
    }
}

