package com.thebluekernel.kmmcommons.utils

import platform.Foundation.*

/**
 * A utility class that handles Multiplatform date operations like
 *
 * [format]
 * comparing [isAfterToday] , [isBeforeToday]
 */
actual class DateUtils actual constructor() {

    actual fun format(dateString: String, pattern: String, locale: String): String? {
        val formatter = NSDateFormatter().apply {
            this.locale = NSLocale(localeIdentifier = locale)
        }
        val dateStringFormat = dateString.datePattern() ?: return null
        formatter.dateFormat = dateStringFormat
        val date = formatter.dateFromString(dateString) ?: return null
        formatter.dateFormat = pattern
        return formatter.stringFromDate(date)
    }

    actual fun isBeforeToday(dateString: String): Boolean {
        val pattern = dateString.datePattern() ?: return false
        val date = makeDate(dateString, pattern) ?: return false
        val now = NSDate()
        return date.earlierDate(now) == date
    }

    actual fun isAfterToday(dateString: String): Boolean {
        val pattern = dateString.datePattern() ?: return false
        val date = makeDate(dateString, pattern) ?: return false
        val now = NSDate()
        return date.laterDate(now) == date
    }

    private fun makeDate(dateString: String, pattern: String): NSDate? {
        val formatter = NSDateFormatter()
        formatter.dateFormat = pattern
        return formatter.dateFromString(dateString)
    }
}