package com.thebluekernel.kmmcommons.storage

import platform.Foundation.NSBundle
import platform.Foundation.NSUserDefaults

/**
 * Created by Ahmed Ibrahim on 30/07/2022
 */
actual class KeyValueStorage {
    actual companion object {
        private fun getBundleIdentifier() = NSBundle.mainBundle.bundleIdentifier ?: ""

        actual fun clear() {
            NSUserDefaults.standardUserDefaults.removePersistentDomainForName(getBundleIdentifier())
        }

        @Suppress("UNCHECKED_CAST")
        actual fun <T> get(key: String, default: T): T {
            return NSUserDefaults.standardUserDefaults.objectForKey(key) as? T ?: default
        }

        actual fun <T> save(key: String, value: T) {
            NSUserDefaults.standardUserDefaults.setObject(value, key)
        }

        actual fun remove(key: String): Boolean {
            NSUserDefaults.standardUserDefaults.removeObjectForKey(key)
            return true
        }
    }

}