package com.thebluekernel.kmmcommons.utils

import com.thebluekernel.kmmcommons.logging.error
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

/**
 * Created by Ahmed Ibrahim on 06,May,2022
 */

@OptIn(ExperimentalSerializationApi::class)
val json = Json {
    isLenient = true
    prettyPrint = true
    ignoreUnknownKeys = true
    explicitNulls = true
}

inline fun <reified T> T.toJson(): String = json.encodeToString(this)

inline fun <reified T> String.toModel(): T? = try {
    json.decodeFromString<T>(this)
} catch (e: Exception) {
    error("Failed to serialize object", e)
    null
}