package com.thebluekernel.kmmcommons.network

import io.ktor.http.*

/**
 * Created by Ahmed Ibrahim on 09,May,2022
 */
class HttpConfig {
    var baseUrl: String? = null
    var headers: Map<String, String> = mapOf()
    var httpLogLevel: HttpLogLevel = HttpLogLevel.NONE
    var loggerLevel: LoggerLevel = LoggerLevel.DEBUG
    var requestTimeoutMillis: Long = 60_000
    var connectTimeoutMillis: Long = 60_000
    var socketTimeoutMillis: Long = 60_000
    var enableCaching: Boolean = false
    var cachePluginConfig: CachePluginConfig = CachePluginConfig()
}

enum class HttpLogLevel {
    NONE,
    HEADERS,
    BODY,
    ALL
}

enum class LoggerLevel {
    DEBUG,
    VERBOSE,
    ERROR
}