package com.thebluekernel.kmmcommons.websocket

/**
 * Created by Ahmed Ibrahim on 23/07/2022
 */
sealed class WebSocketEvent {
    object Connecting : WebSocketEvent()
    object Connected : WebSocketEvent()
    data class Message(val message: String) : WebSocketEvent()
    data class Error(val error: Throwable) : WebSocketEvent()
    data class Closed(val code: Int, val reason: String) : WebSocketEvent()
    data class Closing(val code: Int, val reason: String) : WebSocketEvent()
}
