package com.thebluekernel.kmmcommons.websocket

/**
 * Created by Ahmed Ibrahim on 23/07/2022
 */
class WebSocket(private val url: String, private val headers: Map<String, String> = emptyMap()) {
    private val client = WebSocketClient()
    private val listener = DefaultWebSocketEventObserver()
    val events = listener.eventsFlow

    fun connect() {
        val request = WSRequest(url, headers)
        client.connect(request, listener)
    }

    fun disconnect() {
        client.close()
    }

    fun send(message: String) {
        client.send(message)
    }
}


data class WSRequest(val url: String, val headers: Map<String, String> = emptyMap())