/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import net.jadler.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

class RequestUtils {
    RequestUtils() {
    }

    static Request convert(HttpServletRequest source) throws IOException {
        Charset encoding = StringUtils.isNotBlank((String)source.getCharacterEncoding()) ? Charset.forName(source.getCharacterEncoding()) : null;
        Request.Builder builder = new Request.Builder().method(source.getMethod()).requestURI(URI.create(source.getRequestURL() + RequestUtils.getQueryString(source))).body(IOUtils.toByteArray((InputStream)source.getInputStream()));
        if (encoding != null) {
            builder.encoding(encoding);
        }
        return RequestUtils.addHeaders(builder, source).build();
    }

    private static String getQueryString(HttpServletRequest source) {
        return source.getQueryString() != null ? "?" + source.getQueryString() : "";
    }

    private static Request.Builder addHeaders(Request.Builder builder, HttpServletRequest req) {
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            while (values.hasMoreElements()) {
                builder.header(name, (String)values.nextElement());
            }
        }
        return builder;
    }
}

