/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jetty;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jadler.stubbing.StubResponse;
import net.jadler.stubbing.StubResponseProvider;
import org.apache.commons.collections.MultiMap;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class StubHandler
extends AbstractHandler {
    private final StubResponseProvider ruleProvider;

    public StubHandler(StubResponseProvider ruleProvider) {
        this.ruleProvider = ruleProvider;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StubResponse stubResponse = this.ruleProvider.provideStubResponseFor(request);
        this.setResponseHeaders(stubResponse.getHeaders(), response);
        this.setStatus(stubResponse.getStatus(), response);
        this.processTimeout(stubResponse.getTimeout());
        this.writeResponseBody(stubResponse.getBody(), response);
        baseRequest.setHandled(true);
    }

    private void writeResponseBody(byte[] body, HttpServletResponse response) throws IOException {
        if (body.length > 0) {
            ServletOutputStream os = response.getOutputStream();
            os.write(body);
        }
    }

    private void setStatus(int status, HttpServletResponse response) {
        response.setStatus(status);
    }

    private void setResponseHeaders(MultiMap headers, HttpServletResponse response) {
        for (Map.Entry e : headers.entrySet()) {
            for (String value : (Collection)e.getValue()) {
                response.addHeader((String)e.getKey(), value);
            }
        }
    }

    private void processTimeout(long timeout) {
        if (timeout > 0L) {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

