/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jetty;

import net.jadler.stubbing.StubResponseProvider;
import net.jadler.stubbing.server.StubHttpServer;
import net.jadler.stubbing.server.jetty.StubHandler;
import org.apache.commons.lang.Validate;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyStubHttpServer
implements StubHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyStubHttpServer.class);
    private final Server server = new Server();
    private final Connector selectChannelConnector = new SelectChannelConnector();

    public JettyStubHttpServer() {
        this(0);
    }

    public JettyStubHttpServer(int port) {
        this.selectChannelConnector.setPort(port);
        this.server.addConnector(this.selectChannelConnector);
    }

    public void registerResponseProvider(StubResponseProvider ruleProvider) {
        Validate.notNull((Object)ruleProvider, (String)"ruleProvider cannot be null");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{new StubHandler(ruleProvider), new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
    }

    public void start() throws Exception {
        logger.debug("starting jetty");
        this.server.start();
        logger.debug("jetty started");
    }

    public void stop() throws Exception {
        logger.debug("stopping jetty");
        this.server.stop();
        logger.debug("jetty stopped");
    }

    public int getPort() {
        return this.selectChannelConnector.getLocalPort();
    }
}

