/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.model.ActivityType;
import net.jacobpeterson.alpaca.openapi.trader.model.OrderStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.trader.JSON;

/**
 * TradingActivities
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:49.163624-08:00[America/Los_Angeles]")
public class TradingActivities {
  public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activity_type";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_TYPE)
  private ActivityType activityType;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_CUM_QTY = "cum_qty";
  @SerializedName(SERIALIZED_NAME_CUM_QTY)
  private String cumQty;

  public static final String SERIALIZED_NAME_LEAVES_QTY = "leaves_qty";
  @SerializedName(SERIALIZED_NAME_LEAVES_QTY)
  private String leavesQty;

  public static final String SERIALIZED_NAME_PRICE = "price";
  @SerializedName(SERIALIZED_NAME_PRICE)
  private String price;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private String side;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_TRANSACTION_TIME = "transaction_time";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TIME)
  private OffsetDateTime transactionTime;

  public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
  @SerializedName(SERIALIZED_NAME_ORDER_ID)
  private UUID orderId;

  /**
   * fill or partial_fill
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    FILL("fill"),
    
    PARTIAL_FILL("partial_fill");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      TypeEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_ORDER_STATUS = "order_status";
  @SerializedName(SERIALIZED_NAME_ORDER_STATUS)
  private OrderStatus orderStatus;

  public TradingActivities() {
  }

  public TradingActivities activityType(ActivityType activityType) {
    this.activityType = activityType;
    return this;
  }

   /**
   * Get activityType
   * @return activityType
  **/
  @javax.annotation.Nullable
  public ActivityType getActivityType() {
    return activityType;
  }

  public void setActivityType(ActivityType activityType) {
    this.activityType = activityType;
  }


  public TradingActivities id(String id) {
    this.id = id;
    return this;
  }

   /**
   * An id for the activity. Always in “::” format. Can be sent as page_token in requests to facilitate the paging of results.
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public TradingActivities cumQty(String cumQty) {
    this.cumQty = cumQty;
    return this;
  }

   /**
   * The cumulative quantity of shares involved in the execution.
   * @return cumQty
  **/
  @javax.annotation.Nullable
  public String getCumQty() {
    return cumQty;
  }

  public void setCumQty(String cumQty) {
    this.cumQty = cumQty;
  }


  public TradingActivities leavesQty(String leavesQty) {
    this.leavesQty = leavesQty;
    return this;
  }

   /**
   * For partially_filled orders, the quantity of shares that are left to be filled. 
   * @return leavesQty
  **/
  @javax.annotation.Nullable
  public String getLeavesQty() {
    return leavesQty;
  }

  public void setLeavesQty(String leavesQty) {
    this.leavesQty = leavesQty;
  }


  public TradingActivities price(String price) {
    this.price = price;
    return this;
  }

   /**
   * The per-share price that the trade was executed at.
   * @return price
  **/
  @javax.annotation.Nullable
  public String getPrice() {
    return price;
  }

  public void setPrice(String price) {
    this.price = price;
  }


  public TradingActivities qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * The number of shares involved in the trade execution.
   * @return qty
  **/
  @javax.annotation.Nullable
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public TradingActivities side(String side) {
    this.side = side;
    return this;
  }

   /**
   * buy or sell
   * @return side
  **/
  @javax.annotation.Nullable
  public String getSide() {
    return side;
  }

  public void setSide(String side) {
    this.side = side;
  }


  public TradingActivities symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The symbol of the security being traded.
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public TradingActivities transactionTime(OffsetDateTime transactionTime) {
    this.transactionTime = transactionTime;
    return this;
  }

   /**
   * The time at which the execution occurred.
   * @return transactionTime
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getTransactionTime() {
    return transactionTime;
  }

  public void setTransactionTime(OffsetDateTime transactionTime) {
    this.transactionTime = transactionTime;
  }


  public TradingActivities orderId(UUID orderId) {
    this.orderId = orderId;
    return this;
  }

   /**
   * The id for the order that filled.
   * @return orderId
  **/
  @javax.annotation.Nullable
  public UUID getOrderId() {
    return orderId;
  }

  public void setOrderId(UUID orderId) {
    this.orderId = orderId;
  }


  public TradingActivities type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * fill or partial_fill
   * @return type
  **/
  @javax.annotation.Nullable
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }


  public TradingActivities orderStatus(OrderStatus orderStatus) {
    this.orderStatus = orderStatus;
    return this;
  }

   /**
   * Get orderStatus
   * @return orderStatus
  **/
  @javax.annotation.Nullable
  public OrderStatus getOrderStatus() {
    return orderStatus;
  }

  public void setOrderStatus(OrderStatus orderStatus) {
    this.orderStatus = orderStatus;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TradingActivities tradingActivities = (TradingActivities) o;
    return Objects.equals(this.activityType, tradingActivities.activityType) &&
        Objects.equals(this.id, tradingActivities.id) &&
        Objects.equals(this.cumQty, tradingActivities.cumQty) &&
        Objects.equals(this.leavesQty, tradingActivities.leavesQty) &&
        Objects.equals(this.price, tradingActivities.price) &&
        Objects.equals(this.qty, tradingActivities.qty) &&
        Objects.equals(this.side, tradingActivities.side) &&
        Objects.equals(this.symbol, tradingActivities.symbol) &&
        Objects.equals(this.transactionTime, tradingActivities.transactionTime) &&
        Objects.equals(this.orderId, tradingActivities.orderId) &&
        Objects.equals(this.type, tradingActivities.type) &&
        Objects.equals(this.orderStatus, tradingActivities.orderStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activityType, id, cumQty, leavesQty, price, qty, side, symbol, transactionTime, orderId, type, orderStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TradingActivities {\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    cumQty: ").append(toIndentedString(cumQty)).append("\n");
    sb.append("    leavesQty: ").append(toIndentedString(leavesQty)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    transactionTime: ").append(toIndentedString(transactionTime)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    orderStatus: ").append(toIndentedString(orderStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("activity_type");
    openapiFields.add("id");
    openapiFields.add("cum_qty");
    openapiFields.add("leaves_qty");
    openapiFields.add("price");
    openapiFields.add("qty");
    openapiFields.add("side");
    openapiFields.add("symbol");
    openapiFields.add("transaction_time");
    openapiFields.add("order_id");
    openapiFields.add("type");
    openapiFields.add("order_status");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!TradingActivities.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in TradingActivities is not found in the empty JSON string", TradingActivities.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!TradingActivities.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TradingActivities` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `activity_type`
      if (jsonObj.get("activity_type") != null && !jsonObj.get("activity_type").isJsonNull()) {
        ActivityType.validateJsonElement(jsonObj.get("activity_type"));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("cum_qty") != null && !jsonObj.get("cum_qty").isJsonNull()) && !jsonObj.get("cum_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cum_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cum_qty").toString()));
      }
      if ((jsonObj.get("leaves_qty") != null && !jsonObj.get("leaves_qty").isJsonNull()) && !jsonObj.get("leaves_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `leaves_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("leaves_qty").toString()));
      }
      if ((jsonObj.get("price") != null && !jsonObj.get("price").isJsonNull()) && !jsonObj.get("price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("price").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("side") != null && !jsonObj.get("side").isJsonNull()) && !jsonObj.get("side").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `side` to be a primitive type in the JSON string but got `%s`", jsonObj.get("side").toString()));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("order_id") != null && !jsonObj.get("order_id").isJsonNull()) && !jsonObj.get("order_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("order_id").toString()));
      }
      if ((jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      // validate the optional field `type`
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) {
        TypeEnum.validateJsonElement(jsonObj.get("type"));
      }
      // validate the optional field `order_status`
      if (jsonObj.get("order_status") != null && !jsonObj.get("order_status").isJsonNull()) {
        OrderStatus.validateJsonElement(jsonObj.get("order_status"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TradingActivities.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TradingActivities' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TradingActivities> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TradingActivities.class));

       return (TypeAdapter<T>) new TypeAdapter<TradingActivities>() {
           @Override
           public void write(JsonWriter out, TradingActivities value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TradingActivities read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TradingActivities given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TradingActivities
  * @throws IOException if the JSON string is invalid with respect to TradingActivities
  */
  public static TradingActivities fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TradingActivities.class);
  }

 /**
  * Convert an instance of TradingActivities to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

