/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.trader.model.OrderClass;
import net.jacobpeterson.alpaca.openapi.trader.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.trader.model.OrderType;
import net.jacobpeterson.alpaca.openapi.trader.model.TimeInForce;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.trader.JSON;

/**
 * PostOrderRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:49.163624-08:00[America/Los_Angeles]")
public class PostOrderRequest {
  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public static final String SERIALIZED_NAME_NOTIONAL = "notional";
  @SerializedName(SERIALIZED_NAME_NOTIONAL)
  private String notional;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private OrderSide side;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private OrderType type;

  public static final String SERIALIZED_NAME_TIME_IN_FORCE = "time_in_force";
  @SerializedName(SERIALIZED_NAME_TIME_IN_FORCE)
  private TimeInForce timeInForce;

  public static final String SERIALIZED_NAME_LIMIT_PRICE = "limit_price";
  @SerializedName(SERIALIZED_NAME_LIMIT_PRICE)
  private String limitPrice;

  public static final String SERIALIZED_NAME_STOP_PRICE = "stop_price";
  @SerializedName(SERIALIZED_NAME_STOP_PRICE)
  private String stopPrice;

  public static final String SERIALIZED_NAME_TRAIL_PRICE = "trail_price";
  @SerializedName(SERIALIZED_NAME_TRAIL_PRICE)
  private String trailPrice;

  public static final String SERIALIZED_NAME_TRAIL_PERCENT = "trail_percent";
  @SerializedName(SERIALIZED_NAME_TRAIL_PERCENT)
  private String trailPercent;

  public static final String SERIALIZED_NAME_EXTENDED_HOURS = "extended_hours";
  @SerializedName(SERIALIZED_NAME_EXTENDED_HOURS)
  private Boolean extendedHours;

  public static final String SERIALIZED_NAME_CLIENT_ORDER_ID = "client_order_id";
  @SerializedName(SERIALIZED_NAME_CLIENT_ORDER_ID)
  private String clientOrderId;

  public static final String SERIALIZED_NAME_ORDER_CLASS = "order_class";
  @SerializedName(SERIALIZED_NAME_ORDER_CLASS)
  private OrderClass orderClass;

  public static final String SERIALIZED_NAME_TAKE_PROFIT = "take_profit";
  @SerializedName(SERIALIZED_NAME_TAKE_PROFIT)
  private Object takeProfit;

  public static final String SERIALIZED_NAME_STOP_LOSS = "stop_loss";
  @SerializedName(SERIALIZED_NAME_STOP_LOSS)
  private Object stopLoss;

  public PostOrderRequest() {
  }

  public PostOrderRequest symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * symbol, asset ID, or currency pair to identify the asset to trade
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public PostOrderRequest qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * number of shares to trade. Can be fractionable for only market and day order types.
   * @return qty
  **/
  @javax.annotation.Nullable
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public PostOrderRequest notional(String notional) {
    this.notional = notional;
    return this;
  }

   /**
   * dollar amount to trade. Cannot work with &#x60;qty&#x60;. Can only work for market order types and day for time in force.
   * @return notional
  **/
  @javax.annotation.Nullable
  public String getNotional() {
    return notional;
  }

  public void setNotional(String notional) {
    this.notional = notional;
  }


  public PostOrderRequest side(OrderSide side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @javax.annotation.Nonnull
  public OrderSide getSide() {
    return side;
  }

  public void setSide(OrderSide side) {
    this.side = side;
  }


  public PostOrderRequest type(OrderType type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nonnull
  public OrderType getType() {
    return type;
  }

  public void setType(OrderType type) {
    this.type = type;
  }


  public PostOrderRequest timeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
    return this;
  }

   /**
   * Get timeInForce
   * @return timeInForce
  **/
  @javax.annotation.Nonnull
  public TimeInForce getTimeInForce() {
    return timeInForce;
  }

  public void setTimeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
  }


  public PostOrderRequest limitPrice(String limitPrice) {
    this.limitPrice = limitPrice;
    return this;
  }

   /**
   * required if type is &#x60;limit&#x60; or &#x60;stop_limit&#x60;
   * @return limitPrice
  **/
  @javax.annotation.Nullable
  public String getLimitPrice() {
    return limitPrice;
  }

  public void setLimitPrice(String limitPrice) {
    this.limitPrice = limitPrice;
  }


  public PostOrderRequest stopPrice(String stopPrice) {
    this.stopPrice = stopPrice;
    return this;
  }

   /**
   * required if type is &#x60;stop&#x60; or &#x60;stop_limit&#x60;
   * @return stopPrice
  **/
  @javax.annotation.Nullable
  public String getStopPrice() {
    return stopPrice;
  }

  public void setStopPrice(String stopPrice) {
    this.stopPrice = stopPrice;
  }


  public PostOrderRequest trailPrice(String trailPrice) {
    this.trailPrice = trailPrice;
    return this;
  }

   /**
   * this or &#x60;trail_percent&#x60; is required if type is &#x60;trailing_stop&#x60;
   * @return trailPrice
  **/
  @javax.annotation.Nullable
  public String getTrailPrice() {
    return trailPrice;
  }

  public void setTrailPrice(String trailPrice) {
    this.trailPrice = trailPrice;
  }


  public PostOrderRequest trailPercent(String trailPercent) {
    this.trailPercent = trailPercent;
    return this;
  }

   /**
   * this or &#x60;trail_price&#x60; is required if type is &#x60;trailing_stop&#x60;
   * @return trailPercent
  **/
  @javax.annotation.Nullable
  public String getTrailPercent() {
    return trailPercent;
  }

  public void setTrailPercent(String trailPercent) {
    this.trailPercent = trailPercent;
  }


  public PostOrderRequest extendedHours(Boolean extendedHours) {
    this.extendedHours = extendedHours;
    return this;
  }

   /**
   * (default) false. If true, order will be eligible to execute in premarket/afterhours. Only works with type limit and time_in_force day.
   * @return extendedHours
  **/
  @javax.annotation.Nullable
  public Boolean getExtendedHours() {
    return extendedHours;
  }

  public void setExtendedHours(Boolean extendedHours) {
    this.extendedHours = extendedHours;
  }


  public PostOrderRequest clientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
    return this;
  }

   /**
   * A unique identifier for the order. Automatically generated if not sent.
   * @return clientOrderId
  **/
  @javax.annotation.Nullable
  public String getClientOrderId() {
    return clientOrderId;
  }

  public void setClientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
  }


  public PostOrderRequest orderClass(OrderClass orderClass) {
    this.orderClass = orderClass;
    return this;
  }

   /**
   * Get orderClass
   * @return orderClass
  **/
  @javax.annotation.Nullable
  public OrderClass getOrderClass() {
    return orderClass;
  }

  public void setOrderClass(OrderClass orderClass) {
    this.orderClass = orderClass;
  }


  public PostOrderRequest takeProfit(Object takeProfit) {
    this.takeProfit = takeProfit;
    return this;
  }

   /**
   * Additional parameters for take-profit leg of advanced orders
   * @return takeProfit
  **/
  @javax.annotation.Nullable
  public Object getTakeProfit() {
    return takeProfit;
  }

  public void setTakeProfit(Object takeProfit) {
    this.takeProfit = takeProfit;
  }


  public PostOrderRequest stopLoss(Object stopLoss) {
    this.stopLoss = stopLoss;
    return this;
  }

   /**
   * Additional parameters for stop-loss leg of advanced orders
   * @return stopLoss
  **/
  @javax.annotation.Nullable
  public Object getStopLoss() {
    return stopLoss;
  }

  public void setStopLoss(Object stopLoss) {
    this.stopLoss = stopLoss;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PostOrderRequest postOrderRequest = (PostOrderRequest) o;
    return Objects.equals(this.symbol, postOrderRequest.symbol) &&
        Objects.equals(this.qty, postOrderRequest.qty) &&
        Objects.equals(this.notional, postOrderRequest.notional) &&
        Objects.equals(this.side, postOrderRequest.side) &&
        Objects.equals(this.type, postOrderRequest.type) &&
        Objects.equals(this.timeInForce, postOrderRequest.timeInForce) &&
        Objects.equals(this.limitPrice, postOrderRequest.limitPrice) &&
        Objects.equals(this.stopPrice, postOrderRequest.stopPrice) &&
        Objects.equals(this.trailPrice, postOrderRequest.trailPrice) &&
        Objects.equals(this.trailPercent, postOrderRequest.trailPercent) &&
        Objects.equals(this.extendedHours, postOrderRequest.extendedHours) &&
        Objects.equals(this.clientOrderId, postOrderRequest.clientOrderId) &&
        Objects.equals(this.orderClass, postOrderRequest.orderClass) &&
        Objects.equals(this.takeProfit, postOrderRequest.takeProfit) &&
        Objects.equals(this.stopLoss, postOrderRequest.stopLoss);
  }

  @Override
  public int hashCode() {
    return Objects.hash(symbol, qty, notional, side, type, timeInForce, limitPrice, stopPrice, trailPrice, trailPercent, extendedHours, clientOrderId, orderClass, takeProfit, stopLoss);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PostOrderRequest {\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    notional: ").append(toIndentedString(notional)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    timeInForce: ").append(toIndentedString(timeInForce)).append("\n");
    sb.append("    limitPrice: ").append(toIndentedString(limitPrice)).append("\n");
    sb.append("    stopPrice: ").append(toIndentedString(stopPrice)).append("\n");
    sb.append("    trailPrice: ").append(toIndentedString(trailPrice)).append("\n");
    sb.append("    trailPercent: ").append(toIndentedString(trailPercent)).append("\n");
    sb.append("    extendedHours: ").append(toIndentedString(extendedHours)).append("\n");
    sb.append("    clientOrderId: ").append(toIndentedString(clientOrderId)).append("\n");
    sb.append("    orderClass: ").append(toIndentedString(orderClass)).append("\n");
    sb.append("    takeProfit: ").append(toIndentedString(takeProfit)).append("\n");
    sb.append("    stopLoss: ").append(toIndentedString(stopLoss)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("symbol");
    openapiFields.add("qty");
    openapiFields.add("notional");
    openapiFields.add("side");
    openapiFields.add("type");
    openapiFields.add("time_in_force");
    openapiFields.add("limit_price");
    openapiFields.add("stop_price");
    openapiFields.add("trail_price");
    openapiFields.add("trail_percent");
    openapiFields.add("extended_hours");
    openapiFields.add("client_order_id");
    openapiFields.add("order_class");
    openapiFields.add("take_profit");
    openapiFields.add("stop_loss");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("side");
    openapiRequiredFields.add("type");
    openapiRequiredFields.add("time_in_force");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!PostOrderRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PostOrderRequest is not found in the empty JSON string", PostOrderRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PostOrderRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PostOrderRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PostOrderRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("notional") != null && !jsonObj.get("notional").isJsonNull()) && !jsonObj.get("notional").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `notional` to be a primitive type in the JSON string but got `%s`", jsonObj.get("notional").toString()));
      }
      // validate the required field `side`
      OrderSide.validateJsonElement(jsonObj.get("side"));
      // validate the required field `type`
      OrderType.validateJsonElement(jsonObj.get("type"));
      // validate the required field `time_in_force`
      TimeInForce.validateJsonElement(jsonObj.get("time_in_force"));
      if ((jsonObj.get("limit_price") != null && !jsonObj.get("limit_price").isJsonNull()) && !jsonObj.get("limit_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `limit_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("limit_price").toString()));
      }
      if ((jsonObj.get("stop_price") != null && !jsonObj.get("stop_price").isJsonNull()) && !jsonObj.get("stop_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `stop_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("stop_price").toString()));
      }
      if ((jsonObj.get("trail_price") != null && !jsonObj.get("trail_price").isJsonNull()) && !jsonObj.get("trail_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trail_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trail_price").toString()));
      }
      if ((jsonObj.get("trail_percent") != null && !jsonObj.get("trail_percent").isJsonNull()) && !jsonObj.get("trail_percent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trail_percent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trail_percent").toString()));
      }
      if ((jsonObj.get("client_order_id") != null && !jsonObj.get("client_order_id").isJsonNull()) && !jsonObj.get("client_order_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_order_id").toString()));
      }
      // validate the optional field `order_class`
      if (jsonObj.get("order_class") != null && !jsonObj.get("order_class").isJsonNull()) {
        OrderClass.validateJsonElement(jsonObj.get("order_class"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PostOrderRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PostOrderRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PostOrderRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PostOrderRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<PostOrderRequest>() {
           @Override
           public void write(JsonWriter out, PostOrderRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PostOrderRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PostOrderRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PostOrderRequest
  * @throws IOException if the JSON string is invalid with respect to PostOrderRequest
  */
  public static PostOrderRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PostOrderRequest.class);
  }

 /**
  * Convert an instance of PostOrderRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

