/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.trader.model.Exchange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.trader.JSON;

/**
 * The positions API provides information about an account’s current open positions. The response will include information such as cost basis, shares traded, and market value, which will be updated live as price information is updated. Once a position is closed, it will no longer be queryable through this API.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:49.163624-08:00[America/Los_Angeles]")
public class Position {
  public static final String SERIALIZED_NAME_ASSET_ID = "asset_id";
  @SerializedName(SERIALIZED_NAME_ASSET_ID)
  private UUID assetId;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_EXCHANGE = "exchange";
  @SerializedName(SERIALIZED_NAME_EXCHANGE)
  private Exchange exchange;

  public static final String SERIALIZED_NAME_ASSET_CLASS = "asset_class";
  @SerializedName(SERIALIZED_NAME_ASSET_CLASS)
  private AssetClass assetClass;

  public static final String SERIALIZED_NAME_AVG_ENTRY_PRICE = "avg_entry_price";
  @SerializedName(SERIALIZED_NAME_AVG_ENTRY_PRICE)
  private String avgEntryPrice;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public static final String SERIALIZED_NAME_QTY_AVAILABLE = "qty_available";
  @SerializedName(SERIALIZED_NAME_QTY_AVAILABLE)
  private String qtyAvailable;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private String side;

  public static final String SERIALIZED_NAME_MARKET_VALUE = "market_value";
  @SerializedName(SERIALIZED_NAME_MARKET_VALUE)
  private String marketValue;

  public static final String SERIALIZED_NAME_COST_BASIS = "cost_basis";
  @SerializedName(SERIALIZED_NAME_COST_BASIS)
  private String costBasis;

  public static final String SERIALIZED_NAME_UNREALIZED_PL = "unrealized_pl";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_PL)
  private String unrealizedPl;

  public static final String SERIALIZED_NAME_UNREALIZED_PLPC = "unrealized_plpc";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_PLPC)
  private String unrealizedPlpc;

  public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PL = "unrealized_intraday_pl";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_INTRADAY_PL)
  private String unrealizedIntradayPl;

  public static final String SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC = "unrealized_intraday_plpc";
  @SerializedName(SERIALIZED_NAME_UNREALIZED_INTRADAY_PLPC)
  private String unrealizedIntradayPlpc;

  public static final String SERIALIZED_NAME_CURRENT_PRICE = "current_price";
  @SerializedName(SERIALIZED_NAME_CURRENT_PRICE)
  private String currentPrice;

  public static final String SERIALIZED_NAME_LASTDAY_PRICE = "lastday_price";
  @SerializedName(SERIALIZED_NAME_LASTDAY_PRICE)
  private String lastdayPrice;

  public static final String SERIALIZED_NAME_CHANGE_TODAY = "change_today";
  @SerializedName(SERIALIZED_NAME_CHANGE_TODAY)
  private String changeToday;

  public static final String SERIALIZED_NAME_ASSET_MARGINABLE = "asset_marginable";
  @SerializedName(SERIALIZED_NAME_ASSET_MARGINABLE)
  private Boolean assetMarginable;

  public Position() {
  }

  public Position assetId(UUID assetId) {
    this.assetId = assetId;
    return this;
  }

   /**
   * Asset ID (For options this represents the option contract ID)
   * @return assetId
  **/
  @javax.annotation.Nonnull
  public UUID getAssetId() {
    return assetId;
  }

  public void setAssetId(UUID assetId) {
    this.assetId = assetId;
  }


  public Position symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Symbol name of the asset
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public Position exchange(Exchange exchange) {
    this.exchange = exchange;
    return this;
  }

   /**
   * Get exchange
   * @return exchange
  **/
  @javax.annotation.Nonnull
  public Exchange getExchange() {
    return exchange;
  }

  public void setExchange(Exchange exchange) {
    this.exchange = exchange;
  }


  public Position assetClass(AssetClass assetClass) {
    this.assetClass = assetClass;
    return this;
  }

   /**
   * Get assetClass
   * @return assetClass
  **/
  @javax.annotation.Nonnull
  public AssetClass getAssetClass() {
    return assetClass;
  }

  public void setAssetClass(AssetClass assetClass) {
    this.assetClass = assetClass;
  }


  public Position avgEntryPrice(String avgEntryPrice) {
    this.avgEntryPrice = avgEntryPrice;
    return this;
  }

   /**
   * Average entry price of the position
   * @return avgEntryPrice
  **/
  @javax.annotation.Nonnull
  public String getAvgEntryPrice() {
    return avgEntryPrice;
  }

  public void setAvgEntryPrice(String avgEntryPrice) {
    this.avgEntryPrice = avgEntryPrice;
  }


  public Position qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * The number of shares
   * @return qty
  **/
  @javax.annotation.Nonnull
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public Position qtyAvailable(String qtyAvailable) {
    this.qtyAvailable = qtyAvailable;
    return this;
  }

   /**
   * Total number of shares available minus open orders
   * @return qtyAvailable
  **/
  @javax.annotation.Nullable
  public String getQtyAvailable() {
    return qtyAvailable;
  }

  public void setQtyAvailable(String qtyAvailable) {
    this.qtyAvailable = qtyAvailable;
  }


  public Position side(String side) {
    this.side = side;
    return this;
  }

   /**
   * “long”
   * @return side
  **/
  @javax.annotation.Nonnull
  public String getSide() {
    return side;
  }

  public void setSide(String side) {
    this.side = side;
  }


  public Position marketValue(String marketValue) {
    this.marketValue = marketValue;
    return this;
  }

   /**
   * Total dollar amount of the position
   * @return marketValue
  **/
  @javax.annotation.Nonnull
  public String getMarketValue() {
    return marketValue;
  }

  public void setMarketValue(String marketValue) {
    this.marketValue = marketValue;
  }


  public Position costBasis(String costBasis) {
    this.costBasis = costBasis;
    return this;
  }

   /**
   * Total cost basis in dollar
   * @return costBasis
  **/
  @javax.annotation.Nonnull
  public String getCostBasis() {
    return costBasis;
  }

  public void setCostBasis(String costBasis) {
    this.costBasis = costBasis;
  }


  public Position unrealizedPl(String unrealizedPl) {
    this.unrealizedPl = unrealizedPl;
    return this;
  }

   /**
   * Unrealized profit/loss in dollars
   * @return unrealizedPl
  **/
  @javax.annotation.Nonnull
  public String getUnrealizedPl() {
    return unrealizedPl;
  }

  public void setUnrealizedPl(String unrealizedPl) {
    this.unrealizedPl = unrealizedPl;
  }


  public Position unrealizedPlpc(String unrealizedPlpc) {
    this.unrealizedPlpc = unrealizedPlpc;
    return this;
  }

   /**
   * Unrealized profit/loss percent (by a factor of 1)
   * @return unrealizedPlpc
  **/
  @javax.annotation.Nonnull
  public String getUnrealizedPlpc() {
    return unrealizedPlpc;
  }

  public void setUnrealizedPlpc(String unrealizedPlpc) {
    this.unrealizedPlpc = unrealizedPlpc;
  }


  public Position unrealizedIntradayPl(String unrealizedIntradayPl) {
    this.unrealizedIntradayPl = unrealizedIntradayPl;
    return this;
  }

   /**
   * Unrealized profit/loss in dollars for the day
   * @return unrealizedIntradayPl
  **/
  @javax.annotation.Nonnull
  public String getUnrealizedIntradayPl() {
    return unrealizedIntradayPl;
  }

  public void setUnrealizedIntradayPl(String unrealizedIntradayPl) {
    this.unrealizedIntradayPl = unrealizedIntradayPl;
  }


  public Position unrealizedIntradayPlpc(String unrealizedIntradayPlpc) {
    this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
    return this;
  }

   /**
   * Unrealized profit/loss percent (by a factor of 1)
   * @return unrealizedIntradayPlpc
  **/
  @javax.annotation.Nonnull
  public String getUnrealizedIntradayPlpc() {
    return unrealizedIntradayPlpc;
  }

  public void setUnrealizedIntradayPlpc(String unrealizedIntradayPlpc) {
    this.unrealizedIntradayPlpc = unrealizedIntradayPlpc;
  }


  public Position currentPrice(String currentPrice) {
    this.currentPrice = currentPrice;
    return this;
  }

   /**
   * Current asset price per share
   * @return currentPrice
  **/
  @javax.annotation.Nonnull
  public String getCurrentPrice() {
    return currentPrice;
  }

  public void setCurrentPrice(String currentPrice) {
    this.currentPrice = currentPrice;
  }


  public Position lastdayPrice(String lastdayPrice) {
    this.lastdayPrice = lastdayPrice;
    return this;
  }

   /**
   * Last day’s asset price per share based on the closing value of the last trading day
   * @return lastdayPrice
  **/
  @javax.annotation.Nonnull
  public String getLastdayPrice() {
    return lastdayPrice;
  }

  public void setLastdayPrice(String lastdayPrice) {
    this.lastdayPrice = lastdayPrice;
  }


  public Position changeToday(String changeToday) {
    this.changeToday = changeToday;
    return this;
  }

   /**
   * Percent change from last day price (by a factor of 1)
   * @return changeToday
  **/
  @javax.annotation.Nonnull
  public String getChangeToday() {
    return changeToday;
  }

  public void setChangeToday(String changeToday) {
    this.changeToday = changeToday;
  }


  public Position assetMarginable(Boolean assetMarginable) {
    this.assetMarginable = assetMarginable;
    return this;
  }

   /**
   * Get assetMarginable
   * @return assetMarginable
  **/
  @javax.annotation.Nonnull
  public Boolean getAssetMarginable() {
    return assetMarginable;
  }

  public void setAssetMarginable(Boolean assetMarginable) {
    this.assetMarginable = assetMarginable;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Position position = (Position) o;
    return Objects.equals(this.assetId, position.assetId) &&
        Objects.equals(this.symbol, position.symbol) &&
        Objects.equals(this.exchange, position.exchange) &&
        Objects.equals(this.assetClass, position.assetClass) &&
        Objects.equals(this.avgEntryPrice, position.avgEntryPrice) &&
        Objects.equals(this.qty, position.qty) &&
        Objects.equals(this.qtyAvailable, position.qtyAvailable) &&
        Objects.equals(this.side, position.side) &&
        Objects.equals(this.marketValue, position.marketValue) &&
        Objects.equals(this.costBasis, position.costBasis) &&
        Objects.equals(this.unrealizedPl, position.unrealizedPl) &&
        Objects.equals(this.unrealizedPlpc, position.unrealizedPlpc) &&
        Objects.equals(this.unrealizedIntradayPl, position.unrealizedIntradayPl) &&
        Objects.equals(this.unrealizedIntradayPlpc, position.unrealizedIntradayPlpc) &&
        Objects.equals(this.currentPrice, position.currentPrice) &&
        Objects.equals(this.lastdayPrice, position.lastdayPrice) &&
        Objects.equals(this.changeToday, position.changeToday) &&
        Objects.equals(this.assetMarginable, position.assetMarginable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assetId, symbol, exchange, assetClass, avgEntryPrice, qty, qtyAvailable, side, marketValue, costBasis, unrealizedPl, unrealizedPlpc, unrealizedIntradayPl, unrealizedIntradayPlpc, currentPrice, lastdayPrice, changeToday, assetMarginable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Position {\n");
    sb.append("    assetId: ").append(toIndentedString(assetId)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    exchange: ").append(toIndentedString(exchange)).append("\n");
    sb.append("    assetClass: ").append(toIndentedString(assetClass)).append("\n");
    sb.append("    avgEntryPrice: ").append(toIndentedString(avgEntryPrice)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    qtyAvailable: ").append(toIndentedString(qtyAvailable)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    marketValue: ").append(toIndentedString(marketValue)).append("\n");
    sb.append("    costBasis: ").append(toIndentedString(costBasis)).append("\n");
    sb.append("    unrealizedPl: ").append(toIndentedString(unrealizedPl)).append("\n");
    sb.append("    unrealizedPlpc: ").append(toIndentedString(unrealizedPlpc)).append("\n");
    sb.append("    unrealizedIntradayPl: ").append(toIndentedString(unrealizedIntradayPl)).append("\n");
    sb.append("    unrealizedIntradayPlpc: ").append(toIndentedString(unrealizedIntradayPlpc)).append("\n");
    sb.append("    currentPrice: ").append(toIndentedString(currentPrice)).append("\n");
    sb.append("    lastdayPrice: ").append(toIndentedString(lastdayPrice)).append("\n");
    sb.append("    changeToday: ").append(toIndentedString(changeToday)).append("\n");
    sb.append("    assetMarginable: ").append(toIndentedString(assetMarginable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("asset_id");
    openapiFields.add("symbol");
    openapiFields.add("exchange");
    openapiFields.add("asset_class");
    openapiFields.add("avg_entry_price");
    openapiFields.add("qty");
    openapiFields.add("qty_available");
    openapiFields.add("side");
    openapiFields.add("market_value");
    openapiFields.add("cost_basis");
    openapiFields.add("unrealized_pl");
    openapiFields.add("unrealized_plpc");
    openapiFields.add("unrealized_intraday_pl");
    openapiFields.add("unrealized_intraday_plpc");
    openapiFields.add("current_price");
    openapiFields.add("lastday_price");
    openapiFields.add("change_today");
    openapiFields.add("asset_marginable");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("asset_id");
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("exchange");
    openapiRequiredFields.add("asset_class");
    openapiRequiredFields.add("avg_entry_price");
    openapiRequiredFields.add("qty");
    openapiRequiredFields.add("side");
    openapiRequiredFields.add("market_value");
    openapiRequiredFields.add("cost_basis");
    openapiRequiredFields.add("unrealized_pl");
    openapiRequiredFields.add("unrealized_plpc");
    openapiRequiredFields.add("unrealized_intraday_pl");
    openapiRequiredFields.add("unrealized_intraday_plpc");
    openapiRequiredFields.add("current_price");
    openapiRequiredFields.add("lastday_price");
    openapiRequiredFields.add("change_today");
    openapiRequiredFields.add("asset_marginable");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Position.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Position is not found in the empty JSON string", Position.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Position.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Position` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Position.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("asset_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `asset_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("asset_id").toString()));
      }
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      // validate the required field `exchange`
      Exchange.validateJsonElement(jsonObj.get("exchange"));
      // validate the required field `asset_class`
      AssetClass.validateJsonElement(jsonObj.get("asset_class"));
      if (!jsonObj.get("avg_entry_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `avg_entry_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("avg_entry_price").toString()));
      }
      if (!jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("qty_available") != null && !jsonObj.get("qty_available").isJsonNull()) && !jsonObj.get("qty_available").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty_available` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty_available").toString()));
      }
      if (!jsonObj.get("side").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `side` to be a primitive type in the JSON string but got `%s`", jsonObj.get("side").toString()));
      }
      if (!jsonObj.get("market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("market_value").toString()));
      }
      if (!jsonObj.get("cost_basis").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cost_basis` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cost_basis").toString()));
      }
      if (!jsonObj.get("unrealized_pl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_pl").toString()));
      }
      if (!jsonObj.get("unrealized_plpc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_plpc").toString()));
      }
      if (!jsonObj.get("unrealized_intraday_pl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_pl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_intraday_pl").toString()));
      }
      if (!jsonObj.get("unrealized_intraday_plpc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `unrealized_intraday_plpc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("unrealized_intraday_plpc").toString()));
      }
      if (!jsonObj.get("current_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `current_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("current_price").toString()));
      }
      if (!jsonObj.get("lastday_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lastday_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lastday_price").toString()));
      }
      if (!jsonObj.get("change_today").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `change_today` to be a primitive type in the JSON string but got `%s`", jsonObj.get("change_today").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Position.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Position' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Position> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Position.class));

       return (TypeAdapter<T>) new TypeAdapter<Position>() {
           @Override
           public void write(JsonWriter out, Position value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Position read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Position given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Position
  * @throws IOException if the JSON string is invalid with respect to Position
  */
  public static Position fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Position.class);
  }

 /**
  * Convert an instance of Position to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

