/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.trader.model.ActivityType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.trader.JSON;

/**
 * NonTradeActivities
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:49.163624-08:00[America/Los_Angeles]")
public class NonTradeActivities {
  public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activity_type";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_TYPE)
  private ActivityType activityType;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private OffsetDateTime date;

  public static final String SERIALIZED_NAME_NET_AMOUNT = "net_amount";
  @SerializedName(SERIALIZED_NAME_NET_AMOUNT)
  private String netAmount;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public static final String SERIALIZED_NAME_PER_SHARE_AMOUNT = "per_share_amount";
  @SerializedName(SERIALIZED_NAME_PER_SHARE_AMOUNT)
  private String perShareAmount;

  public NonTradeActivities() {
  }

  public NonTradeActivities activityType(ActivityType activityType) {
    this.activityType = activityType;
    return this;
  }

   /**
   * Get activityType
   * @return activityType
  **/
  @javax.annotation.Nullable
  public ActivityType getActivityType() {
    return activityType;
  }

  public void setActivityType(ActivityType activityType) {
    this.activityType = activityType;
  }


  public NonTradeActivities id(String id) {
    this.id = id;
    return this;
  }

   /**
   * An ID for the activity, always in “::” format. Can be sent as page_token in requests to facilitate the paging of results.
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public NonTradeActivities date(OffsetDateTime date) {
    this.date = date;
    return this;
  }

   /**
   * The date on which the activity occurred or on which the transaction associated with the activity settled.
   * @return date
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getDate() {
    return date;
  }

  public void setDate(OffsetDateTime date) {
    this.date = date;
  }


  public NonTradeActivities netAmount(String netAmount) {
    this.netAmount = netAmount;
    return this;
  }

   /**
   * The net amount of money (positive or negative) associated with the activity.
   * @return netAmount
  **/
  @javax.annotation.Nullable
  public String getNetAmount() {
    return netAmount;
  }

  public void setNetAmount(String netAmount) {
    this.netAmount = netAmount;
  }


  public NonTradeActivities symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The symbol of the security involved with the activity. Not present for all activity types.
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public NonTradeActivities qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * For dividend activities, the number of shares that contributed to the payment. Not present for other activity types. 
   * @return qty
  **/
  @javax.annotation.Nullable
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public NonTradeActivities perShareAmount(String perShareAmount) {
    this.perShareAmount = perShareAmount;
    return this;
  }

   /**
   * For dividend activities, the average amount paid per share. Not present for other activity types.
   * @return perShareAmount
  **/
  @javax.annotation.Nullable
  public String getPerShareAmount() {
    return perShareAmount;
  }

  public void setPerShareAmount(String perShareAmount) {
    this.perShareAmount = perShareAmount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NonTradeActivities nonTradeActivities = (NonTradeActivities) o;
    return Objects.equals(this.activityType, nonTradeActivities.activityType) &&
        Objects.equals(this.id, nonTradeActivities.id) &&
        Objects.equals(this.date, nonTradeActivities.date) &&
        Objects.equals(this.netAmount, nonTradeActivities.netAmount) &&
        Objects.equals(this.symbol, nonTradeActivities.symbol) &&
        Objects.equals(this.qty, nonTradeActivities.qty) &&
        Objects.equals(this.perShareAmount, nonTradeActivities.perShareAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activityType, id, date, netAmount, symbol, qty, perShareAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NonTradeActivities {\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    perShareAmount: ").append(toIndentedString(perShareAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("activity_type");
    openapiFields.add("id");
    openapiFields.add("date");
    openapiFields.add("net_amount");
    openapiFields.add("symbol");
    openapiFields.add("qty");
    openapiFields.add("per_share_amount");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!NonTradeActivities.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in NonTradeActivities is not found in the empty JSON string", NonTradeActivities.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!NonTradeActivities.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NonTradeActivities` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `activity_type`
      if (jsonObj.get("activity_type") != null && !jsonObj.get("activity_type").isJsonNull()) {
        ActivityType.validateJsonElement(jsonObj.get("activity_type"));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("net_amount") != null && !jsonObj.get("net_amount").isJsonNull()) && !jsonObj.get("net_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_amount").toString()));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("per_share_amount") != null && !jsonObj.get("per_share_amount").isJsonNull()) && !jsonObj.get("per_share_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `per_share_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("per_share_amount").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!NonTradeActivities.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'NonTradeActivities' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<NonTradeActivities> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(NonTradeActivities.class));

       return (TypeAdapter<T>) new TypeAdapter<NonTradeActivities>() {
           @Override
           public void write(JsonWriter out, NonTradeActivities value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public NonTradeActivities read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of NonTradeActivities given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of NonTradeActivities
  * @throws IOException if the JSON string is invalid with respect to NonTradeActivities
  */
  public static NonTradeActivities fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, NonTradeActivities.class);
  }

 /**
  * Convert an instance of NonTradeActivities to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

