/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.trader.model.Exchange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.trader.JSON;

/**
 * The assets API serves as the master list of assets available for trade and data consumption from Alpaca. Assets are sorted by asset class, exchange and symbol. Some assets are only available for data consumption via Polygon, and are not tradable with Alpaca. These assets will be marked with the flag tradable&#x3D;false. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:49.163624-08:00[America/Los_Angeles]")
public class Assets {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_PROPERTY_CLASS = "class";
  @SerializedName(SERIALIZED_NAME_PROPERTY_CLASS)
  private AssetClass propertyClass;

  public static final String SERIALIZED_NAME_EXCHANGE = "exchange";
  @SerializedName(SERIALIZED_NAME_EXCHANGE)
  private Exchange exchange;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * active or inactive
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    ACTIVE("active"),
    
    INACTIVE("inactive");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      StatusEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TRADABLE = "tradable";
  @SerializedName(SERIALIZED_NAME_TRADABLE)
  private Boolean tradable;

  public static final String SERIALIZED_NAME_MARGINABLE = "marginable";
  @SerializedName(SERIALIZED_NAME_MARGINABLE)
  private Boolean marginable;

  public static final String SERIALIZED_NAME_SHORTABLE = "shortable";
  @SerializedName(SERIALIZED_NAME_SHORTABLE)
  private Boolean shortable;

  public static final String SERIALIZED_NAME_EASY_TO_BORROW = "easy_to_borrow";
  @SerializedName(SERIALIZED_NAME_EASY_TO_BORROW)
  private Boolean easyToBorrow;

  public static final String SERIALIZED_NAME_FRACTIONABLE = "fractionable";
  @SerializedName(SERIALIZED_NAME_FRACTIONABLE)
  private Boolean fractionable;

  public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT = "maintenance_margin_requirement";
  @SerializedName(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT)
  private String maintenanceMarginRequirement;

  /**
   * Gets or Sets attributes
   */
  @JsonAdapter(AttributesEnum.Adapter.class)
  public enum AttributesEnum {
    PTP_NO_EXCEPTION("ptp_no_exception"),
    
    PTP_WITH_EXCEPTION("ptp_with_exception"),
    
    IPO("ipo"),
    
    OPTIONS_ENABLED("options_enabled");

    private String value;

    AttributesEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AttributesEnum fromValue(String value) {
      for (AttributesEnum b : AttributesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<AttributesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AttributesEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AttributesEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AttributesEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      AttributesEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
  @SerializedName(SERIALIZED_NAME_ATTRIBUTES)
  private List<AttributesEnum> attributes;

  public Assets() {
  }

  public Assets id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Asset ID
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public Assets propertyClass(AssetClass propertyClass) {
    this.propertyClass = propertyClass;
    return this;
  }

   /**
   * Get propertyClass
   * @return propertyClass
  **/
  @javax.annotation.Nonnull
  public AssetClass getPropertyClass() {
    return propertyClass;
  }

  public void setPropertyClass(AssetClass propertyClass) {
    this.propertyClass = propertyClass;
  }


  public Assets exchange(Exchange exchange) {
    this.exchange = exchange;
    return this;
  }

   /**
   * Get exchange
   * @return exchange
  **/
  @javax.annotation.Nonnull
  public Exchange getExchange() {
    return exchange;
  }

  public void setExchange(Exchange exchange) {
    this.exchange = exchange;
  }


  public Assets symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The symbol of the asset
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public Assets name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The official name of the asset
   * @return name
  **/
  @javax.annotation.Nonnull
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public Assets status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * active or inactive
   * @return status
  **/
  @javax.annotation.Nonnull
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Assets tradable(Boolean tradable) {
    this.tradable = tradable;
    return this;
  }

   /**
   * Asset is tradable on Alpaca or not
   * @return tradable
  **/
  @javax.annotation.Nonnull
  public Boolean getTradable() {
    return tradable;
  }

  public void setTradable(Boolean tradable) {
    this.tradable = tradable;
  }


  public Assets marginable(Boolean marginable) {
    this.marginable = marginable;
    return this;
  }

   /**
   * Asset is marginable or not
   * @return marginable
  **/
  @javax.annotation.Nonnull
  public Boolean getMarginable() {
    return marginable;
  }

  public void setMarginable(Boolean marginable) {
    this.marginable = marginable;
  }


  public Assets shortable(Boolean shortable) {
    this.shortable = shortable;
    return this;
  }

   /**
   * Asset is shortable or not
   * @return shortable
  **/
  @javax.annotation.Nonnull
  public Boolean getShortable() {
    return shortable;
  }

  public void setShortable(Boolean shortable) {
    this.shortable = shortable;
  }


  public Assets easyToBorrow(Boolean easyToBorrow) {
    this.easyToBorrow = easyToBorrow;
    return this;
  }

   /**
   * Asset is easy-to-borrow or not (filtering for easy_to_borrow &#x3D; True is the best way to check whether the name is currently available to short at Alpaca).
   * @return easyToBorrow
  **/
  @javax.annotation.Nonnull
  public Boolean getEasyToBorrow() {
    return easyToBorrow;
  }

  public void setEasyToBorrow(Boolean easyToBorrow) {
    this.easyToBorrow = easyToBorrow;
  }


  public Assets fractionable(Boolean fractionable) {
    this.fractionable = fractionable;
    return this;
  }

   /**
   * Asset is fractionable or not
   * @return fractionable
  **/
  @javax.annotation.Nonnull
  public Boolean getFractionable() {
    return fractionable;
  }

  public void setFractionable(Boolean fractionable) {
    this.fractionable = fractionable;
  }


  public Assets maintenanceMarginRequirement(String maintenanceMarginRequirement) {
    this.maintenanceMarginRequirement = maintenanceMarginRequirement;
    return this;
  }

   /**
   * Shows the % margin requirement for the asset (equities only).
   * @return maintenanceMarginRequirement
  **/
  @javax.annotation.Nullable
  public String getMaintenanceMarginRequirement() {
    return maintenanceMarginRequirement;
  }

  public void setMaintenanceMarginRequirement(String maintenanceMarginRequirement) {
    this.maintenanceMarginRequirement = maintenanceMarginRequirement;
  }


  public Assets attributes(List<AttributesEnum> attributes) {
    this.attributes = attributes;
    return this;
  }

  public Assets addAttributesItem(AttributesEnum attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * One of &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, or &#x60;options_enabled&#x60;. We will include unique characteristics of the asset here.
   * @return attributes
  **/
  @javax.annotation.Nullable
  public List<AttributesEnum> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<AttributesEnum> attributes) {
    this.attributes = attributes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Assets assets = (Assets) o;
    return Objects.equals(this.id, assets.id) &&
        Objects.equals(this.propertyClass, assets.propertyClass) &&
        Objects.equals(this.exchange, assets.exchange) &&
        Objects.equals(this.symbol, assets.symbol) &&
        Objects.equals(this.name, assets.name) &&
        Objects.equals(this.status, assets.status) &&
        Objects.equals(this.tradable, assets.tradable) &&
        Objects.equals(this.marginable, assets.marginable) &&
        Objects.equals(this.shortable, assets.shortable) &&
        Objects.equals(this.easyToBorrow, assets.easyToBorrow) &&
        Objects.equals(this.fractionable, assets.fractionable) &&
        Objects.equals(this.maintenanceMarginRequirement, assets.maintenanceMarginRequirement) &&
        Objects.equals(this.attributes, assets.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, propertyClass, exchange, symbol, name, status, tradable, marginable, shortable, easyToBorrow, fractionable, maintenanceMarginRequirement, attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Assets {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    propertyClass: ").append(toIndentedString(propertyClass)).append("\n");
    sb.append("    exchange: ").append(toIndentedString(exchange)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tradable: ").append(toIndentedString(tradable)).append("\n");
    sb.append("    marginable: ").append(toIndentedString(marginable)).append("\n");
    sb.append("    shortable: ").append(toIndentedString(shortable)).append("\n");
    sb.append("    easyToBorrow: ").append(toIndentedString(easyToBorrow)).append("\n");
    sb.append("    fractionable: ").append(toIndentedString(fractionable)).append("\n");
    sb.append("    maintenanceMarginRequirement: ").append(toIndentedString(maintenanceMarginRequirement)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("class");
    openapiFields.add("exchange");
    openapiFields.add("symbol");
    openapiFields.add("name");
    openapiFields.add("status");
    openapiFields.add("tradable");
    openapiFields.add("marginable");
    openapiFields.add("shortable");
    openapiFields.add("easy_to_borrow");
    openapiFields.add("fractionable");
    openapiFields.add("maintenance_margin_requirement");
    openapiFields.add("attributes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("class");
    openapiRequiredFields.add("exchange");
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("name");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("tradable");
    openapiRequiredFields.add("marginable");
    openapiRequiredFields.add("shortable");
    openapiRequiredFields.add("easy_to_borrow");
    openapiRequiredFields.add("fractionable");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Assets.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Assets is not found in the empty JSON string", Assets.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Assets.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Assets` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Assets.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the required field `class`
      AssetClass.validateJsonElement(jsonObj.get("class"));
      // validate the required field `exchange`
      Exchange.validateJsonElement(jsonObj.get("exchange"));
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if (!jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (!jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // validate the required field `status`
      StatusEnum.validateJsonElement(jsonObj.get("status"));
      if ((jsonObj.get("maintenance_margin_requirement") != null && !jsonObj.get("maintenance_margin_requirement").isJsonNull()) && !jsonObj.get("maintenance_margin_requirement").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `maintenance_margin_requirement` to be a primitive type in the JSON string but got `%s`", jsonObj.get("maintenance_margin_requirement").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("attributes") != null && !jsonObj.get("attributes").isJsonNull() && !jsonObj.get("attributes").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get("attributes").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Assets.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Assets' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Assets> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Assets.class));

       return (TypeAdapter<T>) new TypeAdapter<Assets>() {
           @Override
           public void write(JsonWriter out, Assets value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Assets read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Assets given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Assets
  * @throws IOException if the JSON string is invalid with respect to Assets
  */
  public static Assets fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Assets.class);
  }

 /**
  * Convert an instance of Assets to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

