/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * An enum representing the various possible account status values.  Most likely, the account status is ACTIVE unless there is any problem. The account status may get in ACCOUNT_UPDATED when personal information is being updated from the dashboard, in which case you may not be allowed trading for a short period of time until the change is approved.  - ONBOARDING   The account is onboarding. - SUBMISSION_FAILED   The account application submission failed for some reason. - SUBMITTED   The account application has been submitted for review. - ACCOUNT_UPDATED   The account information is being updated. - APPROVAL_PENDING   The final account approval is pending. - ACTIVE   The account is active for trading. - REJECTED   The account application has been rejected.
 */
@JsonAdapter(AccountStatus.Adapter.class)
public enum AccountStatus {
  
  ONBOARDING("ONBOARDING"),
  
  SUBMISSION_FAILED("SUBMISSION_FAILED"),
  
  SUBMITTED("SUBMITTED"),
  
  ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
  
  APPROVAL_PENDING("APPROVAL_PENDING"),
  
  ACTIVE("ACTIVE"),
  
  REJECTED("REJECTED");

  private String value;

  AccountStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static AccountStatus fromValue(String value) {
    for (AccountStatus b : AccountStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<AccountStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final AccountStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public AccountStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return AccountStatus.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    AccountStatus.fromValue(value);
  }
}

