/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.model.AccountStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.trader.JSON;

/**
 * The account API serves important information related to an account, including account status, funds available for trade, funds available for withdrawal, and various flags relevant to an account’s ability to trade. An account maybe be blocked for just for trades (trades_blocked flag) or for both trades and transfers (account_blocked flag) if Alpaca identifies the account to engaging in any suspicious activity. Also, in accordance with FINRA’s pattern day trading rule, an account may be flagged for pattern day trading (pattern_day_trader flag), which would inhibit an account from placing any further day-trades. Please note that cryptocurrencies are not eligible assets to be used as collateral for margin accounts and will require the asset be traded using cash only. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:49.163624-08:00[America/Los_Angeles]")
public class Account {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private AccountStatus status;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_CASH = "cash";
  @SerializedName(SERIALIZED_NAME_CASH)
  private String cash;

  public static final String SERIALIZED_NAME_PORTFOLIO_VALUE = "portfolio_value";
  @SerializedName(SERIALIZED_NAME_PORTFOLIO_VALUE)
  private String portfolioValue;

  public static final String SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER = "non_marginable_buying_power";
  @SerializedName(SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER)
  private String nonMarginableBuyingPower;

  public static final String SERIALIZED_NAME_ACCRUED_FEES = "accrued_fees";
  @SerializedName(SERIALIZED_NAME_ACCRUED_FEES)
  private String accruedFees;

  public static final String SERIALIZED_NAME_PENDING_TRANSFER_IN = "pending_transfer_in";
  @SerializedName(SERIALIZED_NAME_PENDING_TRANSFER_IN)
  private String pendingTransferIn;

  public static final String SERIALIZED_NAME_PENDING_TRANSFER_OUT = "pending_transfer_out";
  @SerializedName(SERIALIZED_NAME_PENDING_TRANSFER_OUT)
  private String pendingTransferOut;

  public static final String SERIALIZED_NAME_PATTERN_DAY_TRADER = "pattern_day_trader";
  @SerializedName(SERIALIZED_NAME_PATTERN_DAY_TRADER)
  private Boolean patternDayTrader;

  public static final String SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER = "trade_suspended_by_user";
  @SerializedName(SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER)
  private Boolean tradeSuspendedByUser;

  public static final String SERIALIZED_NAME_TRADING_BLOCKED = "trading_blocked";
  @SerializedName(SERIALIZED_NAME_TRADING_BLOCKED)
  private Boolean tradingBlocked;

  public static final String SERIALIZED_NAME_TRANSFERS_BLOCKED = "transfers_blocked";
  @SerializedName(SERIALIZED_NAME_TRANSFERS_BLOCKED)
  private Boolean transfersBlocked;

  public static final String SERIALIZED_NAME_ACCOUNT_BLOCKED = "account_blocked";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_BLOCKED)
  private Boolean accountBlocked;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_SHORTING_ENABLED = "shorting_enabled";
  @SerializedName(SERIALIZED_NAME_SHORTING_ENABLED)
  private Boolean shortingEnabled;

  public static final String SERIALIZED_NAME_LONG_MARKET_VALUE = "long_market_value";
  @SerializedName(SERIALIZED_NAME_LONG_MARKET_VALUE)
  private String longMarketValue;

  public static final String SERIALIZED_NAME_SHORT_MARKET_VALUE = "short_market_value";
  @SerializedName(SERIALIZED_NAME_SHORT_MARKET_VALUE)
  private String shortMarketValue;

  public static final String SERIALIZED_NAME_EQUITY = "equity";
  @SerializedName(SERIALIZED_NAME_EQUITY)
  private String equity;

  public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
  @SerializedName(SERIALIZED_NAME_LAST_EQUITY)
  private String lastEquity;

  public static final String SERIALIZED_NAME_MULTIPLIER = "multiplier";
  @SerializedName(SERIALIZED_NAME_MULTIPLIER)
  private String multiplier;

  public static final String SERIALIZED_NAME_BUYING_POWER = "buying_power";
  @SerializedName(SERIALIZED_NAME_BUYING_POWER)
  private String buyingPower;

  public static final String SERIALIZED_NAME_INITIAL_MARGIN = "initial_margin";
  @SerializedName(SERIALIZED_NAME_INITIAL_MARGIN)
  private String initialMargin;

  public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN = "maintenance_margin";
  @SerializedName(SERIALIZED_NAME_MAINTENANCE_MARGIN)
  private String maintenanceMargin;

  public static final String SERIALIZED_NAME_SMA = "sma";
  @SerializedName(SERIALIZED_NAME_SMA)
  private String sma;

  public static final String SERIALIZED_NAME_DAYTRADE_COUNT = "daytrade_count";
  @SerializedName(SERIALIZED_NAME_DAYTRADE_COUNT)
  private Integer daytradeCount;

  public static final String SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN = "last_maintenance_margin";
  @SerializedName(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN)
  private String lastMaintenanceMargin;

  public static final String SERIALIZED_NAME_DAYTRADING_BUYING_POWER = "daytrading_buying_power";
  @SerializedName(SERIALIZED_NAME_DAYTRADING_BUYING_POWER)
  private String daytradingBuyingPower;

  public static final String SERIALIZED_NAME_REGT_BUYING_POWER = "regt_buying_power";
  @SerializedName(SERIALIZED_NAME_REGT_BUYING_POWER)
  private String regtBuyingPower;

  public static final String SERIALIZED_NAME_OPTIONS_BUYING_POWER = "options_buying_power";
  @SerializedName(SERIALIZED_NAME_OPTIONS_BUYING_POWER)
  private String optionsBuyingPower;

  /**
   * The option trading level that was approved for this account. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   */
  @JsonAdapter(OptionsApprovedLevelEnum.Adapter.class)
  public enum OptionsApprovedLevelEnum {
    NUMBER_0(0),
    
    NUMBER_1(1),
    
    NUMBER_2(2);

    private Integer value;

    OptionsApprovedLevelEnum(Integer value) {
      this.value = value;
    }

    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static OptionsApprovedLevelEnum fromValue(Integer value) {
      for (OptionsApprovedLevelEnum b : OptionsApprovedLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<OptionsApprovedLevelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OptionsApprovedLevelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public OptionsApprovedLevelEnum read(final JsonReader jsonReader) throws IOException {
        Integer value =  jsonReader.nextInt();
        return OptionsApprovedLevelEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      Integer value = jsonElement.getAsInt();
      OptionsApprovedLevelEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL = "options_approved_level";
  @SerializedName(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL)
  private OptionsApprovedLevelEnum optionsApprovedLevel;

  /**
   * The effective option trading level of the account. This is the minimum between account options_approved_level and account configurations max_options_trading_level. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   */
  @JsonAdapter(OptionsTradingLevelEnum.Adapter.class)
  public enum OptionsTradingLevelEnum {
    NUMBER_0(0),
    
    NUMBER_1(1),
    
    NUMBER_2(2);

    private Integer value;

    OptionsTradingLevelEnum(Integer value) {
      this.value = value;
    }

    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static OptionsTradingLevelEnum fromValue(Integer value) {
      for (OptionsTradingLevelEnum b : OptionsTradingLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<OptionsTradingLevelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OptionsTradingLevelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public OptionsTradingLevelEnum read(final JsonReader jsonReader) throws IOException {
        Integer value =  jsonReader.nextInt();
        return OptionsTradingLevelEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      Integer value = jsonElement.getAsInt();
      OptionsTradingLevelEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_OPTIONS_TRADING_LEVEL = "options_trading_level";
  @SerializedName(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL)
  private OptionsTradingLevelEnum optionsTradingLevel;

  public Account() {
  }

  public Account id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Account Id. 
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public Account accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * Account number.
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public Account status(AccountStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nonnull
  public AccountStatus getStatus() {
    return status;
  }

  public void setStatus(AccountStatus status) {
    this.status = status;
  }


  public Account currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * USD 
   * @return currency
  **/
  @javax.annotation.Nullable
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Account cash(String cash) {
    this.cash = cash;
    return this;
  }

   /**
   * Cash Balance 
   * @return cash
  **/
  @javax.annotation.Nullable
  public String getCash() {
    return cash;
  }

  public void setCash(String cash) {
    this.cash = cash;
  }


  public Account portfolioValue(String portfolioValue) {
    this.portfolioValue = portfolioValue;
    return this;
  }

   /**
   * Total value of cash + holding positions (This field is deprecated. It is equivalent to the equity field.)
   * @return portfolioValue
  **/
  @javax.annotation.Nullable
  public String getPortfolioValue() {
    return portfolioValue;
  }

  public void setPortfolioValue(String portfolioValue) {
    this.portfolioValue = portfolioValue;
  }


  public Account nonMarginableBuyingPower(String nonMarginableBuyingPower) {
    this.nonMarginableBuyingPower = nonMarginableBuyingPower;
    return this;
  }

   /**
   * Current available non-margin dollar buying power
   * @return nonMarginableBuyingPower
  **/
  @javax.annotation.Nullable
  public String getNonMarginableBuyingPower() {
    return nonMarginableBuyingPower;
  }

  public void setNonMarginableBuyingPower(String nonMarginableBuyingPower) {
    this.nonMarginableBuyingPower = nonMarginableBuyingPower;
  }


  public Account accruedFees(String accruedFees) {
    this.accruedFees = accruedFees;
    return this;
  }

   /**
   * The fees collected.
   * @return accruedFees
  **/
  @javax.annotation.Nullable
  public String getAccruedFees() {
    return accruedFees;
  }

  public void setAccruedFees(String accruedFees) {
    this.accruedFees = accruedFees;
  }


  public Account pendingTransferIn(String pendingTransferIn) {
    this.pendingTransferIn = pendingTransferIn;
    return this;
  }

   /**
   * Cash pending transfer in.
   * @return pendingTransferIn
  **/
  @javax.annotation.Nullable
  public String getPendingTransferIn() {
    return pendingTransferIn;
  }

  public void setPendingTransferIn(String pendingTransferIn) {
    this.pendingTransferIn = pendingTransferIn;
  }


  public Account pendingTransferOut(String pendingTransferOut) {
    this.pendingTransferOut = pendingTransferOut;
    return this;
  }

   /**
   * Cash pending transfer out.
   * @return pendingTransferOut
  **/
  @javax.annotation.Nullable
  public String getPendingTransferOut() {
    return pendingTransferOut;
  }

  public void setPendingTransferOut(String pendingTransferOut) {
    this.pendingTransferOut = pendingTransferOut;
  }


  public Account patternDayTrader(Boolean patternDayTrader) {
    this.patternDayTrader = patternDayTrader;
    return this;
  }

   /**
   * Whether or not the account has been flagged as a pattern day trader
   * @return patternDayTrader
  **/
  @javax.annotation.Nullable
  public Boolean getPatternDayTrader() {
    return patternDayTrader;
  }

  public void setPatternDayTrader(Boolean patternDayTrader) {
    this.patternDayTrader = patternDayTrader;
  }


  public Account tradeSuspendedByUser(Boolean tradeSuspendedByUser) {
    this.tradeSuspendedByUser = tradeSuspendedByUser;
    return this;
  }

   /**
   * User setting. If true, the account is not allowed to place orders.
   * @return tradeSuspendedByUser
  **/
  @javax.annotation.Nullable
  public Boolean getTradeSuspendedByUser() {
    return tradeSuspendedByUser;
  }

  public void setTradeSuspendedByUser(Boolean tradeSuspendedByUser) {
    this.tradeSuspendedByUser = tradeSuspendedByUser;
  }


  public Account tradingBlocked(Boolean tradingBlocked) {
    this.tradingBlocked = tradingBlocked;
    return this;
  }

   /**
   * If true, the account is not allowed to place orders. 
   * @return tradingBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getTradingBlocked() {
    return tradingBlocked;
  }

  public void setTradingBlocked(Boolean tradingBlocked) {
    this.tradingBlocked = tradingBlocked;
  }


  public Account transfersBlocked(Boolean transfersBlocked) {
    this.transfersBlocked = transfersBlocked;
    return this;
  }

   /**
   * If true, the account is not allowed to request money transfers.
   * @return transfersBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getTransfersBlocked() {
    return transfersBlocked;
  }

  public void setTransfersBlocked(Boolean transfersBlocked) {
    this.transfersBlocked = transfersBlocked;
  }


  public Account accountBlocked(Boolean accountBlocked) {
    this.accountBlocked = accountBlocked;
    return this;
  }

   /**
   * If true, the account activity by user is prohibited.
   * @return accountBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getAccountBlocked() {
    return accountBlocked;
  }

  public void setAccountBlocked(Boolean accountBlocked) {
    this.accountBlocked = accountBlocked;
  }


  public Account createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Timestamp this account was created at 
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Account shortingEnabled(Boolean shortingEnabled) {
    this.shortingEnabled = shortingEnabled;
    return this;
  }

   /**
   * Flag to denote whether or not the account is permitted to short
   * @return shortingEnabled
  **/
  @javax.annotation.Nullable
  public Boolean getShortingEnabled() {
    return shortingEnabled;
  }

  public void setShortingEnabled(Boolean shortingEnabled) {
    this.shortingEnabled = shortingEnabled;
  }


  public Account longMarketValue(String longMarketValue) {
    this.longMarketValue = longMarketValue;
    return this;
  }

   /**
   * Real-time MtM value of all long positions held in the account 
   * @return longMarketValue
  **/
  @javax.annotation.Nullable
  public String getLongMarketValue() {
    return longMarketValue;
  }

  public void setLongMarketValue(String longMarketValue) {
    this.longMarketValue = longMarketValue;
  }


  public Account shortMarketValue(String shortMarketValue) {
    this.shortMarketValue = shortMarketValue;
    return this;
  }

   /**
   * Real-time MtM value of all short positions held in the account
   * @return shortMarketValue
  **/
  @javax.annotation.Nullable
  public String getShortMarketValue() {
    return shortMarketValue;
  }

  public void setShortMarketValue(String shortMarketValue) {
    this.shortMarketValue = shortMarketValue;
  }


  public Account equity(String equity) {
    this.equity = equity;
    return this;
  }

   /**
   * Cash + long_market_value + short_market_value
   * @return equity
  **/
  @javax.annotation.Nullable
  public String getEquity() {
    return equity;
  }

  public void setEquity(String equity) {
    this.equity = equity;
  }


  public Account lastEquity(String lastEquity) {
    this.lastEquity = lastEquity;
    return this;
  }

   /**
   * Equity as of previous trading day at 16:00:00 ET
   * @return lastEquity
  **/
  @javax.annotation.Nullable
  public String getLastEquity() {
    return lastEquity;
  }

  public void setLastEquity(String lastEquity) {
    this.lastEquity = lastEquity;
  }


  public Account multiplier(String multiplier) {
    this.multiplier = multiplier;
    return this;
  }

   /**
   * Buying power multiplier that represents account margin classification; valid values 1 (standard limited margin account with 1x buying power), 2 (reg T margin account with 2x intraday and overnight buying power; this is the default for all non-PDT accounts with $2,000 or more equity), 4 (PDT account with 4x intraday buying power and 2x reg T overnight buying power)
   * @return multiplier
  **/
  @javax.annotation.Nullable
  public String getMultiplier() {
    return multiplier;
  }

  public void setMultiplier(String multiplier) {
    this.multiplier = multiplier;
  }


  public Account buyingPower(String buyingPower) {
    this.buyingPower = buyingPower;
    return this;
  }

   /**
   * Current available $ buying power; If multiplier &#x3D; 4, this is your daytrade buying power which is calculated as (last_equity - (last) maintenance_margin) * 4; If multiplier &#x3D; 2, buying_power &#x3D; max(equity – initial_margin,0) * 2; If multiplier &#x3D; 1, buying_power &#x3D; cash
   * @return buyingPower
  **/
  @javax.annotation.Nullable
  public String getBuyingPower() {
    return buyingPower;
  }

  public void setBuyingPower(String buyingPower) {
    this.buyingPower = buyingPower;
  }


  public Account initialMargin(String initialMargin) {
    this.initialMargin = initialMargin;
    return this;
  }

   /**
   * Reg T initial margin requirement (continuously updated value)
   * @return initialMargin
  **/
  @javax.annotation.Nullable
  public String getInitialMargin() {
    return initialMargin;
  }

  public void setInitialMargin(String initialMargin) {
    this.initialMargin = initialMargin;
  }


  public Account maintenanceMargin(String maintenanceMargin) {
    this.maintenanceMargin = maintenanceMargin;
    return this;
  }

   /**
   * Maintenance margin requirement (continuously updated value)
   * @return maintenanceMargin
  **/
  @javax.annotation.Nullable
  public String getMaintenanceMargin() {
    return maintenanceMargin;
  }

  public void setMaintenanceMargin(String maintenanceMargin) {
    this.maintenanceMargin = maintenanceMargin;
  }


  public Account sma(String sma) {
    this.sma = sma;
    return this;
  }

   /**
   * Value of special memorandum account (will be used at a later date to provide additional buying_power)
   * @return sma
  **/
  @javax.annotation.Nullable
  public String getSma() {
    return sma;
  }

  public void setSma(String sma) {
    this.sma = sma;
  }


  public Account daytradeCount(Integer daytradeCount) {
    this.daytradeCount = daytradeCount;
    return this;
  }

   /**
   * The current number of daytrades that have been made in the last 5 trading days (inclusive of today)
   * @return daytradeCount
  **/
  @javax.annotation.Nullable
  public Integer getDaytradeCount() {
    return daytradeCount;
  }

  public void setDaytradeCount(Integer daytradeCount) {
    this.daytradeCount = daytradeCount;
  }


  public Account lastMaintenanceMargin(String lastMaintenanceMargin) {
    this.lastMaintenanceMargin = lastMaintenanceMargin;
    return this;
  }

   /**
   * Your maintenance margin requirement on the previous trading day
   * @return lastMaintenanceMargin
  **/
  @javax.annotation.Nullable
  public String getLastMaintenanceMargin() {
    return lastMaintenanceMargin;
  }

  public void setLastMaintenanceMargin(String lastMaintenanceMargin) {
    this.lastMaintenanceMargin = lastMaintenanceMargin;
  }


  public Account daytradingBuyingPower(String daytradingBuyingPower) {
    this.daytradingBuyingPower = daytradingBuyingPower;
    return this;
  }

   /**
   * Your buying power for day trades (continuously updated value)
   * @return daytradingBuyingPower
  **/
  @javax.annotation.Nullable
  public String getDaytradingBuyingPower() {
    return daytradingBuyingPower;
  }

  public void setDaytradingBuyingPower(String daytradingBuyingPower) {
    this.daytradingBuyingPower = daytradingBuyingPower;
  }


  public Account regtBuyingPower(String regtBuyingPower) {
    this.regtBuyingPower = regtBuyingPower;
    return this;
  }

   /**
   * Your buying power under Regulation T (your excess equity - equity minus margin value - times your margin multiplier) 
   * @return regtBuyingPower
  **/
  @javax.annotation.Nullable
  public String getRegtBuyingPower() {
    return regtBuyingPower;
  }

  public void setRegtBuyingPower(String regtBuyingPower) {
    this.regtBuyingPower = regtBuyingPower;
  }


  public Account optionsBuyingPower(String optionsBuyingPower) {
    this.optionsBuyingPower = optionsBuyingPower;
    return this;
  }

   /**
   * Your buying power for options trading 
   * @return optionsBuyingPower
  **/
  @javax.annotation.Nullable
  public String getOptionsBuyingPower() {
    return optionsBuyingPower;
  }

  public void setOptionsBuyingPower(String optionsBuyingPower) {
    this.optionsBuyingPower = optionsBuyingPower;
  }


  public Account optionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
    this.optionsApprovedLevel = optionsApprovedLevel;
    return this;
  }

   /**
   * The option trading level that was approved for this account. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   * @return optionsApprovedLevel
  **/
  @javax.annotation.Nullable
  public OptionsApprovedLevelEnum getOptionsApprovedLevel() {
    return optionsApprovedLevel;
  }

  public void setOptionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
    this.optionsApprovedLevel = optionsApprovedLevel;
  }


  public Account optionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
    this.optionsTradingLevel = optionsTradingLevel;
    return this;
  }

   /**
   * The effective option trading level of the account. This is the minimum between account options_approved_level and account configurations max_options_trading_level. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put. 
   * @return optionsTradingLevel
  **/
  @javax.annotation.Nullable
  public OptionsTradingLevelEnum getOptionsTradingLevel() {
    return optionsTradingLevel;
  }

  public void setOptionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
    this.optionsTradingLevel = optionsTradingLevel;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(this.id, account.id) &&
        Objects.equals(this.accountNumber, account.accountNumber) &&
        Objects.equals(this.status, account.status) &&
        Objects.equals(this.currency, account.currency) &&
        Objects.equals(this.cash, account.cash) &&
        Objects.equals(this.portfolioValue, account.portfolioValue) &&
        Objects.equals(this.nonMarginableBuyingPower, account.nonMarginableBuyingPower) &&
        Objects.equals(this.accruedFees, account.accruedFees) &&
        Objects.equals(this.pendingTransferIn, account.pendingTransferIn) &&
        Objects.equals(this.pendingTransferOut, account.pendingTransferOut) &&
        Objects.equals(this.patternDayTrader, account.patternDayTrader) &&
        Objects.equals(this.tradeSuspendedByUser, account.tradeSuspendedByUser) &&
        Objects.equals(this.tradingBlocked, account.tradingBlocked) &&
        Objects.equals(this.transfersBlocked, account.transfersBlocked) &&
        Objects.equals(this.accountBlocked, account.accountBlocked) &&
        Objects.equals(this.createdAt, account.createdAt) &&
        Objects.equals(this.shortingEnabled, account.shortingEnabled) &&
        Objects.equals(this.longMarketValue, account.longMarketValue) &&
        Objects.equals(this.shortMarketValue, account.shortMarketValue) &&
        Objects.equals(this.equity, account.equity) &&
        Objects.equals(this.lastEquity, account.lastEquity) &&
        Objects.equals(this.multiplier, account.multiplier) &&
        Objects.equals(this.buyingPower, account.buyingPower) &&
        Objects.equals(this.initialMargin, account.initialMargin) &&
        Objects.equals(this.maintenanceMargin, account.maintenanceMargin) &&
        Objects.equals(this.sma, account.sma) &&
        Objects.equals(this.daytradeCount, account.daytradeCount) &&
        Objects.equals(this.lastMaintenanceMargin, account.lastMaintenanceMargin) &&
        Objects.equals(this.daytradingBuyingPower, account.daytradingBuyingPower) &&
        Objects.equals(this.regtBuyingPower, account.regtBuyingPower) &&
        Objects.equals(this.optionsBuyingPower, account.optionsBuyingPower) &&
        Objects.equals(this.optionsApprovedLevel, account.optionsApprovedLevel) &&
        Objects.equals(this.optionsTradingLevel, account.optionsTradingLevel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountNumber, status, currency, cash, portfolioValue, nonMarginableBuyingPower, accruedFees, pendingTransferIn, pendingTransferOut, patternDayTrader, tradeSuspendedByUser, tradingBlocked, transfersBlocked, accountBlocked, createdAt, shortingEnabled, longMarketValue, shortMarketValue, equity, lastEquity, multiplier, buyingPower, initialMargin, maintenanceMargin, sma, daytradeCount, lastMaintenanceMargin, daytradingBuyingPower, regtBuyingPower, optionsBuyingPower, optionsApprovedLevel, optionsTradingLevel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    cash: ").append(toIndentedString(cash)).append("\n");
    sb.append("    portfolioValue: ").append(toIndentedString(portfolioValue)).append("\n");
    sb.append("    nonMarginableBuyingPower: ").append(toIndentedString(nonMarginableBuyingPower)).append("\n");
    sb.append("    accruedFees: ").append(toIndentedString(accruedFees)).append("\n");
    sb.append("    pendingTransferIn: ").append(toIndentedString(pendingTransferIn)).append("\n");
    sb.append("    pendingTransferOut: ").append(toIndentedString(pendingTransferOut)).append("\n");
    sb.append("    patternDayTrader: ").append(toIndentedString(patternDayTrader)).append("\n");
    sb.append("    tradeSuspendedByUser: ").append(toIndentedString(tradeSuspendedByUser)).append("\n");
    sb.append("    tradingBlocked: ").append(toIndentedString(tradingBlocked)).append("\n");
    sb.append("    transfersBlocked: ").append(toIndentedString(transfersBlocked)).append("\n");
    sb.append("    accountBlocked: ").append(toIndentedString(accountBlocked)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    shortingEnabled: ").append(toIndentedString(shortingEnabled)).append("\n");
    sb.append("    longMarketValue: ").append(toIndentedString(longMarketValue)).append("\n");
    sb.append("    shortMarketValue: ").append(toIndentedString(shortMarketValue)).append("\n");
    sb.append("    equity: ").append(toIndentedString(equity)).append("\n");
    sb.append("    lastEquity: ").append(toIndentedString(lastEquity)).append("\n");
    sb.append("    multiplier: ").append(toIndentedString(multiplier)).append("\n");
    sb.append("    buyingPower: ").append(toIndentedString(buyingPower)).append("\n");
    sb.append("    initialMargin: ").append(toIndentedString(initialMargin)).append("\n");
    sb.append("    maintenanceMargin: ").append(toIndentedString(maintenanceMargin)).append("\n");
    sb.append("    sma: ").append(toIndentedString(sma)).append("\n");
    sb.append("    daytradeCount: ").append(toIndentedString(daytradeCount)).append("\n");
    sb.append("    lastMaintenanceMargin: ").append(toIndentedString(lastMaintenanceMargin)).append("\n");
    sb.append("    daytradingBuyingPower: ").append(toIndentedString(daytradingBuyingPower)).append("\n");
    sb.append("    regtBuyingPower: ").append(toIndentedString(regtBuyingPower)).append("\n");
    sb.append("    optionsBuyingPower: ").append(toIndentedString(optionsBuyingPower)).append("\n");
    sb.append("    optionsApprovedLevel: ").append(toIndentedString(optionsApprovedLevel)).append("\n");
    sb.append("    optionsTradingLevel: ").append(toIndentedString(optionsTradingLevel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_number");
    openapiFields.add("status");
    openapiFields.add("currency");
    openapiFields.add("cash");
    openapiFields.add("portfolio_value");
    openapiFields.add("non_marginable_buying_power");
    openapiFields.add("accrued_fees");
    openapiFields.add("pending_transfer_in");
    openapiFields.add("pending_transfer_out");
    openapiFields.add("pattern_day_trader");
    openapiFields.add("trade_suspended_by_user");
    openapiFields.add("trading_blocked");
    openapiFields.add("transfers_blocked");
    openapiFields.add("account_blocked");
    openapiFields.add("created_at");
    openapiFields.add("shorting_enabled");
    openapiFields.add("long_market_value");
    openapiFields.add("short_market_value");
    openapiFields.add("equity");
    openapiFields.add("last_equity");
    openapiFields.add("multiplier");
    openapiFields.add("buying_power");
    openapiFields.add("initial_margin");
    openapiFields.add("maintenance_margin");
    openapiFields.add("sma");
    openapiFields.add("daytrade_count");
    openapiFields.add("last_maintenance_margin");
    openapiFields.add("daytrading_buying_power");
    openapiFields.add("regt_buying_power");
    openapiFields.add("options_buying_power");
    openapiFields.add("options_approved_level");
    openapiFields.add("options_trading_level");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("status");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Account.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Account is not found in the empty JSON string", Account.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Account.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Account` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Account.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_number") != null && !jsonObj.get("account_number").isJsonNull()) && !jsonObj.get("account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number").toString()));
      }
      // validate the required field `status`
      AccountStatus.validateJsonElement(jsonObj.get("status"));
      if ((jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonNull()) && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if ((jsonObj.get("cash") != null && !jsonObj.get("cash").isJsonNull()) && !jsonObj.get("cash").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cash` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cash").toString()));
      }
      if ((jsonObj.get("portfolio_value") != null && !jsonObj.get("portfolio_value").isJsonNull()) && !jsonObj.get("portfolio_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `portfolio_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("portfolio_value").toString()));
      }
      if ((jsonObj.get("non_marginable_buying_power") != null && !jsonObj.get("non_marginable_buying_power").isJsonNull()) && !jsonObj.get("non_marginable_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `non_marginable_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("non_marginable_buying_power").toString()));
      }
      if ((jsonObj.get("accrued_fees") != null && !jsonObj.get("accrued_fees").isJsonNull()) && !jsonObj.get("accrued_fees").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `accrued_fees` to be a primitive type in the JSON string but got `%s`", jsonObj.get("accrued_fees").toString()));
      }
      if ((jsonObj.get("pending_transfer_in") != null && !jsonObj.get("pending_transfer_in").isJsonNull()) && !jsonObj.get("pending_transfer_in").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `pending_transfer_in` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pending_transfer_in").toString()));
      }
      if ((jsonObj.get("pending_transfer_out") != null && !jsonObj.get("pending_transfer_out").isJsonNull()) && !jsonObj.get("pending_transfer_out").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `pending_transfer_out` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pending_transfer_out").toString()));
      }
      if ((jsonObj.get("long_market_value") != null && !jsonObj.get("long_market_value").isJsonNull()) && !jsonObj.get("long_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `long_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("long_market_value").toString()));
      }
      if ((jsonObj.get("short_market_value") != null && !jsonObj.get("short_market_value").isJsonNull()) && !jsonObj.get("short_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `short_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("short_market_value").toString()));
      }
      if ((jsonObj.get("equity") != null && !jsonObj.get("equity").isJsonNull()) && !jsonObj.get("equity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("equity").toString()));
      }
      if ((jsonObj.get("last_equity") != null && !jsonObj.get("last_equity").isJsonNull()) && !jsonObj.get("last_equity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_equity").toString()));
      }
      if ((jsonObj.get("multiplier") != null && !jsonObj.get("multiplier").isJsonNull()) && !jsonObj.get("multiplier").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `multiplier` to be a primitive type in the JSON string but got `%s`", jsonObj.get("multiplier").toString()));
      }
      if ((jsonObj.get("buying_power") != null && !jsonObj.get("buying_power").isJsonNull()) && !jsonObj.get("buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("buying_power").toString()));
      }
      if ((jsonObj.get("initial_margin") != null && !jsonObj.get("initial_margin").isJsonNull()) && !jsonObj.get("initial_margin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `initial_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("initial_margin").toString()));
      }
      if ((jsonObj.get("maintenance_margin") != null && !jsonObj.get("maintenance_margin").isJsonNull()) && !jsonObj.get("maintenance_margin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("maintenance_margin").toString()));
      }
      if ((jsonObj.get("sma") != null && !jsonObj.get("sma").isJsonNull()) && !jsonObj.get("sma").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sma` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sma").toString()));
      }
      if ((jsonObj.get("last_maintenance_margin") != null && !jsonObj.get("last_maintenance_margin").isJsonNull()) && !jsonObj.get("last_maintenance_margin").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_maintenance_margin").toString()));
      }
      if ((jsonObj.get("daytrading_buying_power") != null && !jsonObj.get("daytrading_buying_power").isJsonNull()) && !jsonObj.get("daytrading_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `daytrading_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("daytrading_buying_power").toString()));
      }
      if ((jsonObj.get("regt_buying_power") != null && !jsonObj.get("regt_buying_power").isJsonNull()) && !jsonObj.get("regt_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `regt_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("regt_buying_power").toString()));
      }
      if ((jsonObj.get("options_buying_power") != null && !jsonObj.get("options_buying_power").isJsonNull()) && !jsonObj.get("options_buying_power").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `options_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get("options_buying_power").toString()));
      }
      // validate the optional field `options_approved_level`
      if (jsonObj.get("options_approved_level") != null && !jsonObj.get("options_approved_level").isJsonNull()) {
        OptionsApprovedLevelEnum.validateJsonElement(jsonObj.get("options_approved_level"));
      }
      // validate the optional field `options_trading_level`
      if (jsonObj.get("options_trading_level") != null && !jsonObj.get("options_trading_level").isJsonNull()) {
        OptionsTradingLevelEnum.validateJsonElement(jsonObj.get("options_trading_level"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Account.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Account' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Account> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Account.class));

       return (TypeAdapter<T>) new TypeAdapter<Account>() {
           @Override
           public void write(JsonWriter out, Account value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Account read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Account given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Account
  * @throws IOException if the JSON string is invalid with respect to Account
  */
  public static Account fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Account.class);
  }

 /**
  * Convert an instance of Account to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

