/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.trader.model.AddAssetToWatchlistByNameRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.AddAssetToWatchlistRequest;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.model.UpdateWatchlistRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.Watchlist;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WatchlistsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WatchlistsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WatchlistsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for addAssetToWatchlist
     * @param watchlistId watchlist id (required)
     * @param addAssetToWatchlistRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call addAssetToWatchlistCall(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = addAssetToWatchlistRequest;

        // create path and map variables
        String localVarPath = "/v2/watchlists/{watchlist_id}"
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addAssetToWatchlistValidateBeforeCall(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling addAssetToWatchlist(Async)");
        }

        return addAssetToWatchlistCall(watchlistId, addAssetToWatchlistRequest, _callback);

    }

    /**
     * Add Asset to Watchlist
     * Append an asset for the symbol to the end of watchlist asset list
     * @param watchlistId watchlist id (required)
     * @param addAssetToWatchlistRequest  (optional)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist addAssetToWatchlist(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = addAssetToWatchlistWithHttpInfo(watchlistId, addAssetToWatchlistRequest);
        return localVarResp.getData();
    }

    /**
     * Add Asset to Watchlist
     * Append an asset for the symbol to the end of watchlist asset list
     * @param watchlistId watchlist id (required)
     * @param addAssetToWatchlistRequest  (optional)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> addAssetToWatchlistWithHttpInfo(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest) throws ApiException {
        okhttp3.Call localVarCall = addAssetToWatchlistValidateBeforeCall(watchlistId, addAssetToWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add Asset to Watchlist (asynchronously)
     * Append an asset for the symbol to the end of watchlist asset list
     * @param watchlistId watchlist id (required)
     * @param addAssetToWatchlistRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call addAssetToWatchlistAsync(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = addAssetToWatchlistValidateBeforeCall(watchlistId, addAssetToWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for addAssetToWatchlistByName
     * @param name name of the watchlist (required)
     * @param addAssetToWatchlistByNameRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call addAssetToWatchlistByNameCall(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = addAssetToWatchlistByNameRequest;

        // create path and map variables
        String localVarPath = "/v2/watchlists:by_name";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addAssetToWatchlistByNameValidateBeforeCall(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling addAssetToWatchlistByName(Async)");
        }

        return addAssetToWatchlistByNameCall(name, addAssetToWatchlistByNameRequest, _callback);

    }

    /**
     * Add Asset to Watchlist By Name
     * Append an asset for the symbol to the end of watchlist asset list
     * @param name name of the watchlist (required)
     * @param addAssetToWatchlistByNameRequest  (optional)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist addAssetToWatchlistByName(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = addAssetToWatchlistByNameWithHttpInfo(name, addAssetToWatchlistByNameRequest);
        return localVarResp.getData();
    }

    /**
     * Add Asset to Watchlist By Name
     * Append an asset for the symbol to the end of watchlist asset list
     * @param name name of the watchlist (required)
     * @param addAssetToWatchlistByNameRequest  (optional)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> addAssetToWatchlistByNameWithHttpInfo(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest) throws ApiException {
        okhttp3.Call localVarCall = addAssetToWatchlistByNameValidateBeforeCall(name, addAssetToWatchlistByNameRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add Asset to Watchlist By Name (asynchronously)
     * Append an asset for the symbol to the end of watchlist asset list
     * @param name name of the watchlist (required)
     * @param addAssetToWatchlistByNameRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call addAssetToWatchlistByNameAsync(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = addAssetToWatchlistByNameValidateBeforeCall(name, addAssetToWatchlistByNameRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteWatchlistById
     * @param watchlistId watchlist id (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Watchlist not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteWatchlistByIdCall(UUID watchlistId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/watchlists/{watchlist_id}"
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteWatchlistByIdValidateBeforeCall(UUID watchlistId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling deleteWatchlistById(Async)");
        }

        return deleteWatchlistByIdCall(watchlistId, _callback);

    }

    /**
     * Delete Watchlist By Id
     * Delete a watchlist. This is a permanent deletion.
     * @param watchlistId watchlist id (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Watchlist not found </td><td>  -  </td></tr>
     </table>
     */
    public void deleteWatchlistById(UUID watchlistId) throws ApiException {
        deleteWatchlistByIdWithHttpInfo(watchlistId);
    }

    /**
     * Delete Watchlist By Id
     * Delete a watchlist. This is a permanent deletion.
     * @param watchlistId watchlist id (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Watchlist not found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteWatchlistByIdWithHttpInfo(UUID watchlistId) throws ApiException {
        okhttp3.Call localVarCall = deleteWatchlistByIdValidateBeforeCall(watchlistId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Watchlist By Id (asynchronously)
     * Delete a watchlist. This is a permanent deletion.
     * @param watchlistId watchlist id (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Watchlist not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteWatchlistByIdAsync(UUID watchlistId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteWatchlistByIdValidateBeforeCall(watchlistId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteWatchlistByName
     * @param name name of the watchlist (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteWatchlistByNameCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/watchlists:by_name";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteWatchlistByNameValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteWatchlistByName(Async)");
        }

        return deleteWatchlistByNameCall(name, _callback);

    }

    /**
     * Delete Watchlist By Name
     * Delete a watchlist. This is a permanent deletion.
     * @param name name of the watchlist (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteWatchlistByName(String name) throws ApiException {
        deleteWatchlistByNameWithHttpInfo(name);
    }

    /**
     * Delete Watchlist By Name
     * Delete a watchlist. This is a permanent deletion.
     * @param name name of the watchlist (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteWatchlistByNameWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = deleteWatchlistByNameValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Watchlist By Name (asynchronously)
     * Delete a watchlist. This is a permanent deletion.
     * @param name name of the watchlist (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteWatchlistByNameAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteWatchlistByNameValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWatchlistById
     * @param watchlistId watchlist id (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistByIdCall(UUID watchlistId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/watchlists/{watchlist_id}"
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWatchlistByIdValidateBeforeCall(UUID watchlistId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling getWatchlistById(Async)");
        }

        return getWatchlistByIdCall(watchlistId, _callback);

    }

    /**
     * Get Watchlist by ID
     * Returns a watchlist identified by the ID.
     * @param watchlistId watchlist id (required)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist getWatchlistById(UUID watchlistId) throws ApiException {
        ApiResponse<Watchlist> localVarResp = getWatchlistByIdWithHttpInfo(watchlistId);
        return localVarResp.getData();
    }

    /**
     * Get Watchlist by ID
     * Returns a watchlist identified by the ID.
     * @param watchlistId watchlist id (required)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> getWatchlistByIdWithHttpInfo(UUID watchlistId) throws ApiException {
        okhttp3.Call localVarCall = getWatchlistByIdValidateBeforeCall(watchlistId, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Watchlist by ID (asynchronously)
     * Returns a watchlist identified by the ID.
     * @param watchlistId watchlist id (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistByIdAsync(UUID watchlistId, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWatchlistByIdValidateBeforeCall(watchlistId, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWatchlistByName
     * @param name name of the watchlist (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistByNameCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/watchlists:by_name";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWatchlistByNameValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getWatchlistByName(Async)");
        }

        return getWatchlistByNameCall(name, _callback);

    }

    /**
     * Get Watchlist by Name
     * You can also call GET, PUT, POST and DELETE with watchlist name with another endpoint /v2/watchlists:by_name and query parameter name&#x3D;&lt;watchlist_name&gt;, instead of /v2/watchlists/{watchlist_id} endpoints  Returns a watchlist by name
     * @param name name of the watchlist (required)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist getWatchlistByName(String name) throws ApiException {
        ApiResponse<Watchlist> localVarResp = getWatchlistByNameWithHttpInfo(name);
        return localVarResp.getData();
    }

    /**
     * Get Watchlist by Name
     * You can also call GET, PUT, POST and DELETE with watchlist name with another endpoint /v2/watchlists:by_name and query parameter name&#x3D;&lt;watchlist_name&gt;, instead of /v2/watchlists/{watchlist_id} endpoints  Returns a watchlist by name
     * @param name name of the watchlist (required)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> getWatchlistByNameWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = getWatchlistByNameValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Watchlist by Name (asynchronously)
     * You can also call GET, PUT, POST and DELETE with watchlist name with another endpoint /v2/watchlists:by_name and query parameter name&#x3D;&lt;watchlist_name&gt;, instead of /v2/watchlists/{watchlist_id} endpoints  Returns a watchlist by name
     * @param name name of the watchlist (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistByNameAsync(String name, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWatchlistByNameValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWatchlists
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistsCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/watchlists";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWatchlistsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getWatchlistsCall(_callback);

    }

    /**
     * Get All Watchlists
     * Returns the list of watchlists registered under the account.
     * @return List&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public List<Watchlist> getWatchlists() throws ApiException {
        ApiResponse<List<Watchlist>> localVarResp = getWatchlistsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get All Watchlists
     * Returns the list of watchlists registered under the account.
     * @return ApiResponse&lt;List&lt;Watchlist&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Watchlist>> getWatchlistsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getWatchlistsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get All Watchlists (asynchronously)
     * Returns the list of watchlists registered under the account.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistsAsync(final ApiCallback<List<Watchlist>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWatchlistsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postWatchlist
     * @param updateWatchlistRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postWatchlistCall(UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateWatchlistRequest;

        // create path and map variables
        String localVarPath = "/v2/watchlists";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postWatchlistValidateBeforeCall(UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'updateWatchlistRequest' is set
        if (updateWatchlistRequest == null) {
            throw new ApiException("Missing the required parameter 'updateWatchlistRequest' when calling postWatchlist(Async)");
        }

        return postWatchlistCall(updateWatchlistRequest, _callback);

    }

    /**
     * Create Watchlist
     * Create a new watchlist with initial set of assets.
     * @param updateWatchlistRequest  (required)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist postWatchlist(UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = postWatchlistWithHttpInfo(updateWatchlistRequest);
        return localVarResp.getData();
    }

    /**
     * Create Watchlist
     * Create a new watchlist with initial set of assets.
     * @param updateWatchlistRequest  (required)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> postWatchlistWithHttpInfo(UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        okhttp3.Call localVarCall = postWatchlistValidateBeforeCall(updateWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create Watchlist (asynchronously)
     * Create a new watchlist with initial set of assets.
     * @param updateWatchlistRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postWatchlistAsync(UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = postWatchlistValidateBeforeCall(updateWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for removeAssetFromWatchlist
     * @param watchlistId Watchlist ID (required)
     * @param symbol symbol name to remove from the watchlist content (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the updated watchlist </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call removeAssetFromWatchlistCall(UUID watchlistId, String symbol, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/watchlists/{watchlist_id}/{symbol}"
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()))
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call removeAssetFromWatchlistValidateBeforeCall(UUID watchlistId, String symbol, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling removeAssetFromWatchlist(Async)");
        }

        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling removeAssetFromWatchlist(Async)");
        }

        return removeAssetFromWatchlistCall(watchlistId, symbol, _callback);

    }

    /**
     * Delete Symbol from Watchlist
     * Delete one entry for an asset by symbol name
     * @param watchlistId Watchlist ID (required)
     * @param symbol symbol name to remove from the watchlist content (required)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the updated watchlist </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist removeAssetFromWatchlist(UUID watchlistId, String symbol) throws ApiException {
        ApiResponse<Watchlist> localVarResp = removeAssetFromWatchlistWithHttpInfo(watchlistId, symbol);
        return localVarResp.getData();
    }

    /**
     * Delete Symbol from Watchlist
     * Delete one entry for an asset by symbol name
     * @param watchlistId Watchlist ID (required)
     * @param symbol symbol name to remove from the watchlist content (required)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the updated watchlist </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> removeAssetFromWatchlistWithHttpInfo(UUID watchlistId, String symbol) throws ApiException {
        okhttp3.Call localVarCall = removeAssetFromWatchlistValidateBeforeCall(watchlistId, symbol, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete Symbol from Watchlist (asynchronously)
     * Delete one entry for an asset by symbol name
     * @param watchlistId Watchlist ID (required)
     * @param symbol symbol name to remove from the watchlist content (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the updated watchlist </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call removeAssetFromWatchlistAsync(UUID watchlistId, String symbol, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = removeAssetFromWatchlistValidateBeforeCall(watchlistId, symbol, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateWatchlistById
     * @param watchlistId watchlist id (required)
     * @param updateWatchlistRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call updateWatchlistByIdCall(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateWatchlistRequest;

        // create path and map variables
        String localVarPath = "/v2/watchlists/{watchlist_id}"
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateWatchlistByIdValidateBeforeCall(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling updateWatchlistById(Async)");
        }

        return updateWatchlistByIdCall(watchlistId, updateWatchlistRequest, _callback);

    }

    /**
     * Update Watchlist By Id
     * Update the name and/or content of watchlist
     * @param watchlistId watchlist id (required)
     * @param updateWatchlistRequest  (optional)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist updateWatchlistById(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = updateWatchlistByIdWithHttpInfo(watchlistId, updateWatchlistRequest);
        return localVarResp.getData();
    }

    /**
     * Update Watchlist By Id
     * Update the name and/or content of watchlist
     * @param watchlistId watchlist id (required)
     * @param updateWatchlistRequest  (optional)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> updateWatchlistByIdWithHttpInfo(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        okhttp3.Call localVarCall = updateWatchlistByIdValidateBeforeCall(watchlistId, updateWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Watchlist By Id (asynchronously)
     * Update the name and/or content of watchlist
     * @param watchlistId watchlist id (required)
     * @param updateWatchlistRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call updateWatchlistByIdAsync(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateWatchlistByIdValidateBeforeCall(watchlistId, updateWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateWatchlistByName
     * @param name name of the watchlist (required)
     * @param updateWatchlistRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call updateWatchlistByNameCall(String name, UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateWatchlistRequest;

        // create path and map variables
        String localVarPath = "/v2/watchlists:by_name";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateWatchlistByNameValidateBeforeCall(String name, UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateWatchlistByName(Async)");
        }

        return updateWatchlistByNameCall(name, updateWatchlistRequest, _callback);

    }

    /**
     * Update Watchlist By Name
     * Update the name and/or content of watchlist
     * @param name name of the watchlist (required)
     * @param updateWatchlistRequest  (optional)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist updateWatchlistByName(String name, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = updateWatchlistByNameWithHttpInfo(name, updateWatchlistRequest);
        return localVarResp.getData();
    }

    /**
     * Update Watchlist By Name
     * Update the name and/or content of watchlist
     * @param name name of the watchlist (required)
     * @param updateWatchlistRequest  (optional)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> updateWatchlistByNameWithHttpInfo(String name, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        okhttp3.Call localVarCall = updateWatchlistByNameValidateBeforeCall(name, updateWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Watchlist By Name (asynchronously)
     * Update the name and/or content of watchlist
     * @param name name of the watchlist (required)
     * @param updateWatchlistRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call updateWatchlistByNameAsync(String name, UpdateWatchlistRequest updateWatchlistRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateWatchlistByNameValidateBeforeCall(name, updateWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
