/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.math.BigDecimal;
import net.jacobpeterson.alpaca.openapi.trader.model.Error;
import net.jacobpeterson.alpaca.openapi.trader.model.Order;
import net.jacobpeterson.alpaca.openapi.trader.model.Position;
import net.jacobpeterson.alpaca.openapi.trader.model.PositionClosedReponse;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PositionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PositionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PositionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for deleteAllOpenPositions
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of PositionClosed responses </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteAllOpenPositionsCall(Boolean cancelOrders, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/positions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cancelOrders != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cancel_orders", cancelOrders));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllOpenPositionsValidateBeforeCall(Boolean cancelOrders, final ApiCallback _callback) throws ApiException {
        return deleteAllOpenPositionsCall(cancelOrders, _callback);

    }

    /**
     * Close All Positions
     * Closes (liquidates) all of the account’s open long and short positions. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @return List&lt;PositionClosedReponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of PositionClosed responses </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate </td><td>  -  </td></tr>
     </table>
     */
    public List<PositionClosedReponse> deleteAllOpenPositions(Boolean cancelOrders) throws ApiException {
        ApiResponse<List<PositionClosedReponse>> localVarResp = deleteAllOpenPositionsWithHttpInfo(cancelOrders);
        return localVarResp.getData();
    }

    /**
     * Close All Positions
     * Closes (liquidates) all of the account’s open long and short positions. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @return ApiResponse&lt;List&lt;PositionClosedReponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of PositionClosed responses </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<PositionClosedReponse>> deleteAllOpenPositionsWithHttpInfo(Boolean cancelOrders) throws ApiException {
        okhttp3.Call localVarCall = deleteAllOpenPositionsValidateBeforeCall(cancelOrders, null);
        Type localVarReturnType = new TypeToken<List<PositionClosedReponse>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Close All Positions (asynchronously)
     * Closes (liquidates) all of the account’s open long and short positions. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of PositionClosed responses </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteAllOpenPositionsAsync(Boolean cancelOrders, final ApiCallback<List<PositionClosedReponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllOpenPositionsValidateBeforeCall(cancelOrders, _callback);
        Type localVarReturnType = new TypeToken<List<PositionClosedReponse>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteOpenPosition
     * @param symbolOrAssetId symbol or assetId (required)
     * @param qty the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  Returns the order created to close out this position </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteOpenPositionCall(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/positions/{symbol_or_asset_id}"
            .replace("{" + "symbol_or_asset_id" + "}", localVarApiClient.escapeString(symbolOrAssetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (qty != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("qty", qty));
        }

        if (percentage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("percentage", percentage));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteOpenPositionValidateBeforeCall(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbolOrAssetId' is set
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling deleteOpenPosition(Async)");
        }

        return deleteOpenPositionCall(symbolOrAssetId, qty, percentage, _callback);

    }

    /**
     * Close a Position
     * Closes (liquidates) the account’s open position for the given symbol. Works for both long and short positions.
     * @param symbolOrAssetId symbol or assetId (required)
     * @param qty the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  Returns the order created to close out this position </td><td>  -  </td></tr>
     </table>
     */
    public Order deleteOpenPosition(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage) throws ApiException {
        ApiResponse<Order> localVarResp = deleteOpenPositionWithHttpInfo(symbolOrAssetId, qty, percentage);
        return localVarResp.getData();
    }

    /**
     * Close a Position
     * Closes (liquidates) the account’s open position for the given symbol. Works for both long and short positions.
     * @param symbolOrAssetId symbol or assetId (required)
     * @param qty the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  Returns the order created to close out this position </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> deleteOpenPositionWithHttpInfo(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage) throws ApiException {
        okhttp3.Call localVarCall = deleteOpenPositionValidateBeforeCall(symbolOrAssetId, qty, percentage, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Close a Position (asynchronously)
     * Closes (liquidates) the account’s open position for the given symbol. Works for both long and short positions.
     * @param symbolOrAssetId symbol or assetId (required)
     * @param qty the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  Returns the order created to close out this position </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteOpenPositionAsync(String symbolOrAssetId, BigDecimal qty, BigDecimal percentage, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteOpenPositionValidateBeforeCall(symbolOrAssetId, qty, percentage, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllOpenPositions
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllOpenPositionsCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/positions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllOpenPositionsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getAllOpenPositionsCall(_callback);

    }

    /**
     * All Open Positions
     * The positions API provides information about an account’s current open positions. The response will include information such as cost basis, shares traded, and market value, which will be updated live as price information is updated. Once a position is closed, it will no longer be queryable through this API  Retrieves a list of the account’s open positions
     * @return List&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public List<Position> getAllOpenPositions() throws ApiException {
        ApiResponse<List<Position>> localVarResp = getAllOpenPositionsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * All Open Positions
     * The positions API provides information about an account’s current open positions. The response will include information such as cost basis, shares traded, and market value, which will be updated live as price information is updated. Once a position is closed, it will no longer be queryable through this API  Retrieves a list of the account’s open positions
     * @return ApiResponse&lt;List&lt;Position&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Position>> getAllOpenPositionsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getAllOpenPositionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * All Open Positions (asynchronously)
     * The positions API provides information about an account’s current open positions. The response will include information such as cost basis, shares traded, and market value, which will be updated live as price information is updated. Once a position is closed, it will no longer be queryable through this API  Retrieves a list of the account’s open positions
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllOpenPositionsAsync(final ApiCallback<List<Position>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllOpenPositionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOpenPosition
     * @param symbolOrAssetId symbol or assetId (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOpenPositionCall(String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/positions/{symbol_or_asset_id}"
            .replace("{" + "symbol_or_asset_id" + "}", localVarApiClient.escapeString(symbolOrAssetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOpenPositionValidateBeforeCall(String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbolOrAssetId' is set
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling getOpenPosition(Async)");
        }

        return getOpenPositionCall(symbolOrAssetId, _callback);

    }

    /**
     * Get an Open Position
     * Retrieves the account’s open position for the given symbol or assetId.
     * @param symbolOrAssetId symbol or assetId (required)
     * @return Position
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Position getOpenPosition(String symbolOrAssetId) throws ApiException {
        ApiResponse<Position> localVarResp = getOpenPositionWithHttpInfo(symbolOrAssetId);
        return localVarResp.getData();
    }

    /**
     * Get an Open Position
     * Retrieves the account’s open position for the given symbol or assetId.
     * @param symbolOrAssetId symbol or assetId (required)
     * @return ApiResponse&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Position> getOpenPositionWithHttpInfo(String symbolOrAssetId) throws ApiException {
        okhttp3.Call localVarCall = getOpenPositionValidateBeforeCall(symbolOrAssetId, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an Open Position (asynchronously)
     * Retrieves the account’s open position for the given symbol or assetId.
     * @param symbolOrAssetId symbol or assetId (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOpenPositionAsync(String symbolOrAssetId, final ApiCallback<Position> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOpenPositionValidateBeforeCall(symbolOrAssetId, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionExercise
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid Parameters.  One or more parameters provided are invalid. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call optionExerciseCall(UUID symbolOrContractId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/positions/{symbol_or_contract_id}/exercise"
            .replace("{" + "symbol_or_contract_id" + "}", localVarApiClient.escapeString(symbolOrContractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionExerciseValidateBeforeCall(UUID symbolOrContractId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbolOrContractId' is set
        if (symbolOrContractId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrContractId' when calling optionExercise(Async)");
        }

        return optionExerciseCall(symbolOrContractId, _callback);

    }

    /**
     * Exercise an Options Position (BETA)
     * This endpoint enables users to exercise a held option contract, converting it into the underlying asset based on the specified terms. All available held shares of this option contract will be exercised.  By default, Alpaca will automatically exercise in-the-money (ITM) contracts at expiry. Exercise requests will be processed immediately once received. Exercise requests submitted outside market hours will be rejected. To cancel an exercise request or to submit a Do-not-exercise (DNE) instruction, please contact our support team.
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid Parameters.  One or more parameters provided are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public void optionExercise(UUID symbolOrContractId) throws ApiException {
        optionExerciseWithHttpInfo(symbolOrContractId);
    }

    /**
     * Exercise an Options Position (BETA)
     * This endpoint enables users to exercise a held option contract, converting it into the underlying asset based on the specified terms. All available held shares of this option contract will be exercised.  By default, Alpaca will automatically exercise in-the-money (ITM) contracts at expiry. Exercise requests will be processed immediately once received. Exercise requests submitted outside market hours will be rejected. To cancel an exercise request or to submit a Do-not-exercise (DNE) instruction, please contact our support team.
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid Parameters.  One or more parameters provided are invalid. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> optionExerciseWithHttpInfo(UUID symbolOrContractId) throws ApiException {
        okhttp3.Call localVarCall = optionExerciseValidateBeforeCall(symbolOrContractId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Exercise an Options Position (BETA) (asynchronously)
     * This endpoint enables users to exercise a held option contract, converting it into the underlying asset based on the specified terms. All available held shares of this option contract will be exercised.  By default, Alpaca will automatically exercise in-the-money (ITM) contracts at expiry. Exercise requests will be processed immediately once received. Exercise requests submitted outside market hours will be rejected. To cancel an exercise request or to submit a Do-not-exercise (DNE) instruction, please contact our support team.
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Invalid Parameters.  One or more parameters provided are invalid. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call optionExerciseAsync(UUID symbolOrContractId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionExerciseValidateBeforeCall(symbolOrContractId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
