/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.time.LocalDate;
import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.trader.model.PortfolioHistory;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortfolioHistoryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PortfolioHistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PortfolioHistoryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getAccountPortfolioHistory
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountPortfolioHistoryCall(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/account/portfolio/history";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (period != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("period", period));
        }

        if (timeframe != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeframe", timeframe));
        }

        if (intradayReporting != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("intraday_reporting", intradayReporting));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (pnlReset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pnl_reset", pnlReset));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (dateEnd != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date_end", dateEnd));
        }

        if (extendedHours != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("extended_hours", extendedHours));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountPortfolioHistoryValidateBeforeCall(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, final ApiCallback _callback) throws ApiException {
        return getAccountPortfolioHistoryCall(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, _callback);

    }

    /**
     * Get Account Portfolio History
     * Returns timeseries data about equity and profit/loss (P/L) of the account in requested timespan.
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @return PortfolioHistory
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public PortfolioHistory getAccountPortfolioHistory(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours) throws ApiException {
        ApiResponse<PortfolioHistory> localVarResp = getAccountPortfolioHistoryWithHttpInfo(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours);
        return localVarResp.getData();
    }

    /**
     * Get Account Portfolio History
     * Returns timeseries data about equity and profit/loss (P/L) of the account in requested timespan.
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @return ApiResponse&lt;PortfolioHistory&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<PortfolioHistory> getAccountPortfolioHistoryWithHttpInfo(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours) throws ApiException {
        okhttp3.Call localVarCall = getAccountPortfolioHistoryValidateBeforeCall(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, null);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Account Portfolio History (asynchronously)
     * Returns timeseries data about equity and profit/loss (P/L) of the account in requested timespan.
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountPortfolioHistoryAsync(String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, final ApiCallback<PortfolioHistory> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountPortfolioHistoryValidateBeforeCall(period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, _callback);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
