/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.trader.model.CanceledOrderResponse;
import net.jacobpeterson.alpaca.openapi.trader.model.Order;
import net.jacobpeterson.alpaca.openapi.trader.model.PatchOrderRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.PostOrderRequest;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrdersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrdersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrdersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for deleteAllOrders
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to cancel order. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteAllOrdersCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllOrdersValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return deleteAllOrdersCall(_callback);

    }

    /**
     * All Orders
     * Attempts to cancel all open orders. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @return List&lt;CanceledOrderResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to cancel order. </td><td>  -  </td></tr>
     </table>
     */
    public List<CanceledOrderResponse> deleteAllOrders() throws ApiException {
        ApiResponse<List<CanceledOrderResponse>> localVarResp = deleteAllOrdersWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * All Orders
     * Attempts to cancel all open orders. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @return ApiResponse&lt;List&lt;CanceledOrderResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to cancel order. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<CanceledOrderResponse>> deleteAllOrdersWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = deleteAllOrdersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CanceledOrderResponse>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * All Orders (asynchronously)
     * Attempts to cancel all open orders. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> Multi-Status with body.  an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to cancel order. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteAllOrdersAsync(final ApiCallback<List<CanceledOrderResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllOrdersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CanceledOrderResponse>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteOrderByOrderID
     * @param orderId order id (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The order status is not cancelable. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteOrderByOrderIDCall(UUID orderId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/orders/{order_id}"
            .replace("{" + "order_id" + "}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteOrderByOrderIDValidateBeforeCall(UUID orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling deleteOrderByOrderID(Async)");
        }

        return deleteOrderByOrderIDCall(orderId, _callback);

    }

    /**
     * Delete Order by ID
     * Attempts to cancel an Open Order. If the order is no longer cancelable, the request will be rejected with status 422; otherwise accepted with return status 204.
     * @param orderId order id (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The order status is not cancelable. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteOrderByOrderID(UUID orderId) throws ApiException {
        deleteOrderByOrderIDWithHttpInfo(orderId);
    }

    /**
     * Delete Order by ID
     * Attempts to cancel an Open Order. If the order is no longer cancelable, the request will be rejected with status 422; otherwise accepted with return status 204.
     * @param orderId order id (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The order status is not cancelable. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteOrderByOrderIDWithHttpInfo(UUID orderId) throws ApiException {
        okhttp3.Call localVarCall = deleteOrderByOrderIDValidateBeforeCall(orderId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Order by ID (asynchronously)
     * Attempts to cancel an Open Order. If the order is no longer cancelable, the request will be rejected with status 422; otherwise accepted with return status 204.
     * @param orderId order id (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> The order status is not cancelable. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteOrderByOrderIDAsync(UUID orderId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteOrderByOrderIDValidateBeforeCall(orderId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllOrders
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by (ex. “AAPL,TSLA,MSFT”). A currency pair is required for crypto orders (ex. “BTCUSD,BCHUSD,LTCUSD,ETCUSD”). (optional)
     * @param side Filters down to orders that have a matching side field set. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  An array of Order objects </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllOrdersCall(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (direction != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("direction", direction));
        }

        if (nested != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nested", nested));
        }

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (side != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("side", side));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllOrdersValidateBeforeCall(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side, final ApiCallback _callback) throws ApiException {
        return getAllOrdersCall(status, limit, after, until, direction, nested, symbols, side, _callback);

    }

    /**
     * Get All Orders
     * Retrieves a list of orders for the account, filtered by the supplied query parameters.
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by (ex. “AAPL,TSLA,MSFT”). A currency pair is required for crypto orders (ex. “BTCUSD,BCHUSD,LTCUSD,ETCUSD”). (optional)
     * @param side Filters down to orders that have a matching side field set. (optional)
     * @return List&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  An array of Order objects </td><td>  -  </td></tr>
     </table>
     */
    public List<Order> getAllOrders(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side) throws ApiException {
        ApiResponse<List<Order>> localVarResp = getAllOrdersWithHttpInfo(status, limit, after, until, direction, nested, symbols, side);
        return localVarResp.getData();
    }

    /**
     * Get All Orders
     * Retrieves a list of orders for the account, filtered by the supplied query parameters.
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by (ex. “AAPL,TSLA,MSFT”). A currency pair is required for crypto orders (ex. “BTCUSD,BCHUSD,LTCUSD,ETCUSD”). (optional)
     * @param side Filters down to orders that have a matching side field set. (optional)
     * @return ApiResponse&lt;List&lt;Order&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  An array of Order objects </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Order>> getAllOrdersWithHttpInfo(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side) throws ApiException {
        okhttp3.Call localVarCall = getAllOrdersValidateBeforeCall(status, limit, after, until, direction, nested, symbols, side, null);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get All Orders (asynchronously)
     * Retrieves a list of orders for the account, filtered by the supplied query parameters.
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by (ex. “AAPL,TSLA,MSFT”). A currency pair is required for crypto orders (ex. “BTCUSD,BCHUSD,LTCUSD,ETCUSD”). (optional)
     * @param side Filters down to orders that have a matching side field set. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  An array of Order objects </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllOrdersAsync(String status, Integer limit, String after, String until, String direction, Boolean nested, String symbols, String side, final ApiCallback<List<Order>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllOrdersValidateBeforeCall(status, limit, after, until, direction, nested, symbols, side, _callback);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOrderByOrderID
     * @param orderId order id (required)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOrderByOrderIDCall(UUID orderId, Boolean nested, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/orders/{order_id}"
            .replace("{" + "order_id" + "}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (nested != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nested", nested));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOrderByOrderIDValidateBeforeCall(UUID orderId, Boolean nested, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderByOrderID(Async)");
        }

        return getOrderByOrderIDCall(orderId, nested, _callback);

    }

    /**
     * Get Order by ID
     * Retrieves a single order for the given order_id.
     * @param orderId order id (required)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public Order getOrderByOrderID(UUID orderId, Boolean nested) throws ApiException {
        ApiResponse<Order> localVarResp = getOrderByOrderIDWithHttpInfo(orderId, nested);
        return localVarResp.getData();
    }

    /**
     * Get Order by ID
     * Retrieves a single order for the given order_id.
     * @param orderId order id (required)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> getOrderByOrderIDWithHttpInfo(UUID orderId, Boolean nested) throws ApiException {
        okhttp3.Call localVarCall = getOrderByOrderIDValidateBeforeCall(orderId, nested, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Order by ID (asynchronously)
     * Retrieves a single order for the given order_id.
     * @param orderId order id (required)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOrderByOrderIDAsync(UUID orderId, Boolean nested, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOrderByOrderIDValidateBeforeCall(orderId, nested, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for patchOrderByOrderId
     * @param orderId order id (required)
     * @param patchOrderRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  The new Order object with the new order ID. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchOrderByOrderIdCall(UUID orderId, PatchOrderRequest patchOrderRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = patchOrderRequest;

        // create path and map variables
        String localVarPath = "/v2/orders/{order_id}"
            .replace("{" + "order_id" + "}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchOrderByOrderIdValidateBeforeCall(UUID orderId, PatchOrderRequest patchOrderRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling patchOrderByOrderId(Async)");
        }

        // verify the required parameter 'patchOrderRequest' is set
        if (patchOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'patchOrderRequest' when calling patchOrderByOrderId(Async)");
        }

        return patchOrderByOrderIdCall(orderId, patchOrderRequest, _callback);

    }

    /**
     * Replace Order by ID
     * Replaces a single order with updated parameters. Each parameter overrides the corresponding attribute of the existing order. The other attributes remain the same as the existing order.  A success return code from a replaced order does NOT guarantee the existing open order has been replaced. If the existing open order is filled before the replacing (new) order reaches the execution venue, the replacing (new) order is rejected, and these events are sent in the trade_updates stream channel.  While an order is being replaced, buying power is reduced by the larger of the two orders that have been placed (the old order being replaced, and the newly placed order to replace it). If you are replacing a buy entry order with a higher limit price than the original order, the buying power is calculated based on the newly placed order. If you are replacing it with a lower limit price, the buying power is calculated based on the old order. 
     * @param orderId order id (required)
     * @param patchOrderRequest  (required)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  The new Order object with the new order ID. </td><td>  -  </td></tr>
     </table>
     */
    public Order patchOrderByOrderId(UUID orderId, PatchOrderRequest patchOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = patchOrderByOrderIdWithHttpInfo(orderId, patchOrderRequest);
        return localVarResp.getData();
    }

    /**
     * Replace Order by ID
     * Replaces a single order with updated parameters. Each parameter overrides the corresponding attribute of the existing order. The other attributes remain the same as the existing order.  A success return code from a replaced order does NOT guarantee the existing open order has been replaced. If the existing open order is filled before the replacing (new) order reaches the execution venue, the replacing (new) order is rejected, and these events are sent in the trade_updates stream channel.  While an order is being replaced, buying power is reduced by the larger of the two orders that have been placed (the old order being replaced, and the newly placed order to replace it). If you are replacing a buy entry order with a higher limit price than the original order, the buying power is calculated based on the newly placed order. If you are replacing it with a lower limit price, the buying power is calculated based on the old order. 
     * @param orderId order id (required)
     * @param patchOrderRequest  (required)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  The new Order object with the new order ID. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> patchOrderByOrderIdWithHttpInfo(UUID orderId, PatchOrderRequest patchOrderRequest) throws ApiException {
        okhttp3.Call localVarCall = patchOrderByOrderIdValidateBeforeCall(orderId, patchOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Replace Order by ID (asynchronously)
     * Replaces a single order with updated parameters. Each parameter overrides the corresponding attribute of the existing order. The other attributes remain the same as the existing order.  A success return code from a replaced order does NOT guarantee the existing open order has been replaced. If the existing open order is filled before the replacing (new) order reaches the execution venue, the replacing (new) order is rejected, and these events are sent in the trade_updates stream channel.  While an order is being replaced, buying power is reduced by the larger of the two orders that have been placed (the old order being replaced, and the newly placed order to replace it). If you are replacing a buy entry order with a higher limit price than the original order, the buying power is calculated based on the newly placed order. If you are replacing it with a lower limit price, the buying power is calculated based on the old order. 
     * @param orderId order id (required)
     * @param patchOrderRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response  The new Order object with the new order ID. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchOrderByOrderIdAsync(UUID orderId, PatchOrderRequest patchOrderRequest, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = patchOrderByOrderIdValidateBeforeCall(orderId, patchOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postOrder
     * @param postOrderRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Buying power or shares is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable  Input parameters are not recognized. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postOrderCall(PostOrderRequest postOrderRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = postOrderRequest;

        // create path and map variables
        String localVarPath = "/v2/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postOrderValidateBeforeCall(PostOrderRequest postOrderRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'postOrderRequest' is set
        if (postOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'postOrderRequest' when calling postOrder(Async)");
        }

        return postOrderCall(postOrderRequest, _callback);

    }

    /**
     * Create an Order
     * Places a new order for the given account. An order request may be rejected if the account is not authorized for trading, or if the tradable balance is insufficient to fill the order. Note: Submitting an options order is only available for BETA users.
     * @param postOrderRequest  (required)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Buying power or shares is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable  Input parameters are not recognized. </td><td>  -  </td></tr>
     </table>
     */
    public Order postOrder(PostOrderRequest postOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = postOrderWithHttpInfo(postOrderRequest);
        return localVarResp.getData();
    }

    /**
     * Create an Order
     * Places a new order for the given account. An order request may be rejected if the account is not authorized for trading, or if the tradable balance is insufficient to fill the order. Note: Submitting an options order is only available for BETA users.
     * @param postOrderRequest  (required)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Buying power or shares is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable  Input parameters are not recognized. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> postOrderWithHttpInfo(PostOrderRequest postOrderRequest) throws ApiException {
        okhttp3.Call localVarCall = postOrderValidateBeforeCall(postOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an Order (asynchronously)
     * Places a new order for the given account. An order request may be rejected if the account is not authorized for trading, or if the tradable balance is insufficient to fill the order. Note: Submitting an options order is only available for BETA users.
     * @param postOrderRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Buying power or shares is not sufficient. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable  Input parameters are not recognized. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postOrderAsync(PostOrderRequest postOrderRequest, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = postOrderValidateBeforeCall(postOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
