/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.trader.model.GetV2CorporateActionsAnnouncements200ResponseInner;
import net.jacobpeterson.alpaca.openapi.trader.model.GetV2CorporateActionsAnnouncementsId200Response;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorporateActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CorporateActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporateActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getV2CorporateActionsAnnouncements
     * @param caTypes A comma-delimited list of Dividend, Merger, Spinoff, or Split. (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType declaration_date, ex_date, record_date, or payable_date (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2CorporateActionsAnnouncementsCall(String caTypes, String since, String until, String symbol, String cusip, String dateType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/corporate_actions/announcements";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (caTypes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ca_types", caTypes));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (symbol != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbol", symbol));
        }

        if (cusip != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cusip", cusip));
        }

        if (dateType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date_type", dateType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV2CorporateActionsAnnouncementsValidateBeforeCall(String caTypes, String since, String until, String symbol, String cusip, String dateType, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'caTypes' is set
        if (caTypes == null) {
            throw new ApiException("Missing the required parameter 'caTypes' when calling getV2CorporateActionsAnnouncements(Async)");
        }

        // verify the required parameter 'since' is set
        if (since == null) {
            throw new ApiException("Missing the required parameter 'since' when calling getV2CorporateActionsAnnouncements(Async)");
        }

        // verify the required parameter 'until' is set
        if (until == null) {
            throw new ApiException("Missing the required parameter 'until' when calling getV2CorporateActionsAnnouncements(Async)");
        }

        return getV2CorporateActionsAnnouncementsCall(caTypes, since, until, symbol, cusip, dateType, _callback);

    }

    /**
     * Retrieve Announcements
     * Returns announcements data given specified search criteria.
     * @param caTypes A comma-delimited list of Dividend, Merger, Spinoff, or Split. (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType declaration_date, ex_date, record_date, or payable_date (optional)
     * @return List&lt;GetV2CorporateActionsAnnouncements200ResponseInner&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<GetV2CorporateActionsAnnouncements200ResponseInner> getV2CorporateActionsAnnouncements(String caTypes, String since, String until, String symbol, String cusip, String dateType) throws ApiException {
        ApiResponse<List<GetV2CorporateActionsAnnouncements200ResponseInner>> localVarResp = getV2CorporateActionsAnnouncementsWithHttpInfo(caTypes, since, until, symbol, cusip, dateType);
        return localVarResp.getData();
    }

    /**
     * Retrieve Announcements
     * Returns announcements data given specified search criteria.
     * @param caTypes A comma-delimited list of Dividend, Merger, Spinoff, or Split. (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType declaration_date, ex_date, record_date, or payable_date (optional)
     * @return ApiResponse&lt;List&lt;GetV2CorporateActionsAnnouncements200ResponseInner&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<GetV2CorporateActionsAnnouncements200ResponseInner>> getV2CorporateActionsAnnouncementsWithHttpInfo(String caTypes, String since, String until, String symbol, String cusip, String dateType) throws ApiException {
        okhttp3.Call localVarCall = getV2CorporateActionsAnnouncementsValidateBeforeCall(caTypes, since, until, symbol, cusip, dateType, null);
        Type localVarReturnType = new TypeToken<List<GetV2CorporateActionsAnnouncements200ResponseInner>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Announcements (asynchronously)
     * Returns announcements data given specified search criteria.
     * @param caTypes A comma-delimited list of Dividend, Merger, Spinoff, or Split. (required)
     * @param since The start (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param until The end (inclusive) of the date range when searching corporate action announcements. This should follow the YYYY-MM-DD format. The date range is limited to 90 days. (required)
     * @param symbol The symbol of the company initiating the announcement. (optional)
     * @param cusip The CUSIP of the company initiating the announcement. (optional)
     * @param dateType declaration_date, ex_date, record_date, or payable_date (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2CorporateActionsAnnouncementsAsync(String caTypes, String since, String until, String symbol, String cusip, String dateType, final ApiCallback<List<GetV2CorporateActionsAnnouncements200ResponseInner>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV2CorporateActionsAnnouncementsValidateBeforeCall(caTypes, since, until, symbol, cusip, dateType, _callback);
        Type localVarReturnType = new TypeToken<List<GetV2CorporateActionsAnnouncements200ResponseInner>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV2CorporateActionsAnnouncementsId
     * @param id The corporate announcement’s id (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2CorporateActionsAnnouncementsIdCall(String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/corporate_actions/announcements/{id}"
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV2CorporateActionsAnnouncementsIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getV2CorporateActionsAnnouncementsId(Async)");
        }

        return getV2CorporateActionsAnnouncementsIdCall(id, _callback);

    }

    /**
     * Retrieve a Specific Announcement
     * Returns a specific announcement.
     * @param id The corporate announcement’s id (required)
     * @return GetV2CorporateActionsAnnouncementsId200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public GetV2CorporateActionsAnnouncementsId200Response getV2CorporateActionsAnnouncementsId(String id) throws ApiException {
        ApiResponse<GetV2CorporateActionsAnnouncementsId200Response> localVarResp = getV2CorporateActionsAnnouncementsIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Retrieve a Specific Announcement
     * Returns a specific announcement.
     * @param id The corporate announcement’s id (required)
     * @return ApiResponse&lt;GetV2CorporateActionsAnnouncementsId200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<GetV2CorporateActionsAnnouncementsId200Response> getV2CorporateActionsAnnouncementsIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getV2CorporateActionsAnnouncementsIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<GetV2CorporateActionsAnnouncementsId200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a Specific Announcement (asynchronously)
     * Returns a specific announcement.
     * @param id The corporate announcement’s id (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2CorporateActionsAnnouncementsIdAsync(String id, final ApiCallback<GetV2CorporateActionsAnnouncementsId200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV2CorporateActionsAnnouncementsIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<GetV2CorporateActionsAnnouncementsId200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
