/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.trader.model.Calendar;
import java.time.OffsetDateTime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalendarApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CalendarApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CalendarApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getCalendar
     * @param start The first date to retrieve data for (inclusive) (optional)
     * @param end The last date to retrieve data for (inclusive) (optional)
     * @param dateType Indicates what start and end mean. Enum: ‘TRADING’ or ‘SETTLEMENT’. Default value is ‘TRADING’. If TRADING is specified, returns a calendar whose trading date matches start, end. If SETTLEMENT is specified, returns the calendar whose settlement date matches start and end. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getCalendarCall(OffsetDateTime start, OffsetDateTime end, String dateType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/calendar";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (dateType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date_type", dateType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCalendarValidateBeforeCall(OffsetDateTime start, OffsetDateTime end, String dateType, final ApiCallback _callback) throws ApiException {
        return getCalendarCall(start, end, dateType, _callback);

    }

    /**
     * Get Market Calendar info
     * The calendar API serves the full list of market days from 1970 to 2029. It can also be queried by specifying a start and/or end time to narrow down the results. In addition to the dates, the response also contains the specific open and close times for the market days, taking into account early closures.  Returns the market calendar.
     * @param start The first date to retrieve data for (inclusive) (optional)
     * @param end The last date to retrieve data for (inclusive) (optional)
     * @param dateType Indicates what start and end mean. Enum: ‘TRADING’ or ‘SETTLEMENT’. Default value is ‘TRADING’. If TRADING is specified, returns a calendar whose trading date matches start, end. If SETTLEMENT is specified, returns the calendar whose settlement date matches start and end. (optional)
     * @return List&lt;Calendar&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<Calendar> getCalendar(OffsetDateTime start, OffsetDateTime end, String dateType) throws ApiException {
        ApiResponse<List<Calendar>> localVarResp = getCalendarWithHttpInfo(start, end, dateType);
        return localVarResp.getData();
    }

    /**
     * Get Market Calendar info
     * The calendar API serves the full list of market days from 1970 to 2029. It can also be queried by specifying a start and/or end time to narrow down the results. In addition to the dates, the response also contains the specific open and close times for the market days, taking into account early closures.  Returns the market calendar.
     * @param start The first date to retrieve data for (inclusive) (optional)
     * @param end The last date to retrieve data for (inclusive) (optional)
     * @param dateType Indicates what start and end mean. Enum: ‘TRADING’ or ‘SETTLEMENT’. Default value is ‘TRADING’. If TRADING is specified, returns a calendar whose trading date matches start, end. If SETTLEMENT is specified, returns the calendar whose settlement date matches start and end. (optional)
     * @return ApiResponse&lt;List&lt;Calendar&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Calendar>> getCalendarWithHttpInfo(OffsetDateTime start, OffsetDateTime end, String dateType) throws ApiException {
        okhttp3.Call localVarCall = getCalendarValidateBeforeCall(start, end, dateType, null);
        Type localVarReturnType = new TypeToken<List<Calendar>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Market Calendar info (asynchronously)
     * The calendar API serves the full list of market days from 1970 to 2029. It can also be queried by specifying a start and/or end time to narrow down the results. In addition to the dates, the response also contains the specific open and close times for the market days, taking into account early closures.  Returns the market calendar.
     * @param start The first date to retrieve data for (inclusive) (optional)
     * @param end The last date to retrieve data for (inclusive) (optional)
     * @param dateType Indicates what start and end mean. Enum: ‘TRADING’ or ‘SETTLEMENT’. Default value is ‘TRADING’. If TRADING is specified, returns a calendar whose trading date matches start, end. If SETTLEMENT is specified, returns the calendar whose settlement date matches start and end. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getCalendarAsync(OffsetDateTime start, OffsetDateTime end, String dateType, final ApiCallback<List<Calendar>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCalendarValidateBeforeCall(start, end, dateType, _callback);
        Type localVarReturnType = new TypeToken<List<Calendar>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
