/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.trader.model.Assets;
import java.math.BigDecimal;
import net.jacobpeterson.alpaca.openapi.trader.model.Error;
import net.jacobpeterson.alpaca.openapi.trader.model.GetOptionsContracts200Response;
import java.time.LocalDate;
import net.jacobpeterson.alpaca.openapi.trader.model.OptionContract;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AssetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AssetsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getOptionContractSymbolOrId
     * @param symbolOrId symbol or contract ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionContractSymbolOrIdCall(String symbolOrId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/options/contracts/{symbol_or_id}"
            .replace("{" + "symbol_or_id" + "}", localVarApiClient.escapeString(symbolOrId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionContractSymbolOrIdValidateBeforeCall(String symbolOrId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbolOrId' is set
        if (symbolOrId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrId' when calling getOptionContractSymbolOrId(Async)");
        }

        return getOptionContractSymbolOrIdCall(symbolOrId, _callback);

    }

    /**
     * Get an option contract by ID or Symbol (BETA)
     * Get an option contract by symbol or contract ID. The symbol or id should be passed in as a path parameter.
     * @param symbolOrId symbol or contract ID (required)
     * @return OptionContract
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public OptionContract getOptionContractSymbolOrId(String symbolOrId) throws ApiException {
        ApiResponse<OptionContract> localVarResp = getOptionContractSymbolOrIdWithHttpInfo(symbolOrId);
        return localVarResp.getData();
    }

    /**
     * Get an option contract by ID or Symbol (BETA)
     * Get an option contract by symbol or contract ID. The symbol or id should be passed in as a path parameter.
     * @param symbolOrId symbol or contract ID (required)
     * @return ApiResponse&lt;OptionContract&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<OptionContract> getOptionContractSymbolOrIdWithHttpInfo(String symbolOrId) throws ApiException {
        okhttp3.Call localVarCall = getOptionContractSymbolOrIdValidateBeforeCall(symbolOrId, null);
        Type localVarReturnType = new TypeToken<OptionContract>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an option contract by ID or Symbol (BETA) (asynchronously)
     * Get an option contract by symbol or contract ID. The symbol or id should be passed in as a path parameter.
     * @param symbolOrId symbol or contract ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An option contract </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionContractSymbolOrIdAsync(String symbolOrId, final ApiCallback<OptionContract> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOptionContractSymbolOrIdValidateBeforeCall(symbolOrId, _callback);
        Type localVarReturnType = new TypeToken<OptionContract>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOptionsContracts
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionsContractsCall(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/options/contracts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (underlyingSymbol != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying_symbol", underlyingSymbol));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (expirationDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_date", expirationDate));
        }

        if (expirationDateGte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_date_gte", expirationDateGte));
        }

        if (expirationDateLte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_date_lte", expirationDateLte));
        }

        if (rootSymbol != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("root_symbol", rootSymbol));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (style != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("style", style));
        }

        if (strikePriceGte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("strike_price_gte", strikePriceGte));
        }

        if (strikePriceLte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("strike_price_lte", strikePriceLte));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionsContractsValidateBeforeCall(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlyingSymbol' is set
        if (underlyingSymbol == null) {
            throw new ApiException("Missing the required parameter 'underlyingSymbol' when calling getOptionsContracts(Async)");
        }

        return getOptionsContractsCall(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit, _callback);

    }

    /**
     * Get Option Contracts (BETA)
     * This endpoint allows you to retrieve a list of option contracts based on various filtering criteria.  By default only active contracts that expire before the upcoming weekend are returned. 
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @return GetOptionsContracts200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    public GetOptionsContracts200Response getOptionsContracts(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit) throws ApiException {
        ApiResponse<GetOptionsContracts200Response> localVarResp = getOptionsContractsWithHttpInfo(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit);
        return localVarResp.getData();
    }

    /**
     * Get Option Contracts (BETA)
     * This endpoint allows you to retrieve a list of option contracts based on various filtering criteria.  By default only active contracts that expire before the upcoming weekend are returned. 
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @return ApiResponse&lt;GetOptionsContracts200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<GetOptionsContracts200Response> getOptionsContractsWithHttpInfo(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = getOptionsContractsValidateBeforeCall(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit, null);
        Type localVarReturnType = new TypeToken<GetOptionsContracts200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Option Contracts (BETA) (asynchronously)
     * This endpoint allows you to retrieve a list of option contracts based on various filtering criteria.  By default only active contracts that expire before the upcoming weekend are returned. 
     * @param underlyingSymbol Filter contracts by the symbol of the underlying asset. (required)
     * @param status Filter contracts by status (active/inactive). By default only active contracts are returned. (optional)
     * @param expirationDate Filter contracts by the exact expiration date (format: YYYY-MM-DD). (optional)
     * @param expirationDateGte Filter contracts with expiration date greater than or equal to the specified date. (optional)
     * @param expirationDateLte Filter contracts with expiration date less than or equal to the specified date. By default this is set to the next weekend. (optional)
     * @param rootSymbol Filter contracts by the root symbol. (optional)
     * @param type Filter contracts by the type (call/put). (optional)
     * @param style Filter contracts by the style (american/european). (optional)
     * @param strikePriceGte Filter contracts with strike price greater than or equal to the specified value. (optional)
     * @param strikePriceLte Filter contracts with strike price less than or equal to the specified value. (optional)
     * @param page The desired page number (default&#x3D;1). (optional)
     * @param limit The number of contracts to limit per page (default&#x3D;10000). (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOptionsContractsAsync(String underlyingSymbol, String status, LocalDate expirationDate, LocalDate expirationDateGte, LocalDate expirationDateLte, String rootSymbol, String type, String style, BigDecimal strikePriceGte, BigDecimal strikePriceLte, Integer page, Integer limit, final ApiCallback<GetOptionsContracts200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOptionsContractsValidateBeforeCall(underlyingSymbol, status, expirationDate, expirationDateGte, expirationDateLte, rootSymbol, type, style, strikePriceGte, strikePriceLte, page, limit, _callback);
        Type localVarReturnType = new TypeToken<GetOptionsContracts200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV2Assets
     * @param status e.g. “active”. By default, all statuses are included. (optional)
     * @param assetClass Defaults to us_equity. (optional)
     * @param exchange Optional AMEX, ARCA, BATS, NYSE, NASDAQ, NYSEARCA or OTC (optional)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2AssetsCall(String status, String assetClass, String exchange, List<String> attributes, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/assets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (assetClass != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("asset_class", assetClass));
        }

        if (exchange != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("exchange", exchange));
        }

        if (attributes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "attributes", attributes));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV2AssetsValidateBeforeCall(String status, String assetClass, String exchange, List<String> attributes, final ApiCallback _callback) throws ApiException {
        return getV2AssetsCall(status, assetClass, exchange, attributes, _callback);

    }

    /**
     * Get Assets
     * The assets API serves as the master list of assets available for trade and data consumption from Alpaca. Assets are sorted by asset class, exchange and symbol.
     * @param status e.g. “active”. By default, all statuses are included. (optional)
     * @param assetClass Defaults to us_equity. (optional)
     * @param exchange Optional AMEX, ARCA, BATS, NYSE, NASDAQ, NYSEARCA or OTC (optional)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @return List&lt;Assets&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects </td><td>  -  </td></tr>
     </table>
     */
    public List<Assets> getV2Assets(String status, String assetClass, String exchange, List<String> attributes) throws ApiException {
        ApiResponse<List<Assets>> localVarResp = getV2AssetsWithHttpInfo(status, assetClass, exchange, attributes);
        return localVarResp.getData();
    }

    /**
     * Get Assets
     * The assets API serves as the master list of assets available for trade and data consumption from Alpaca. Assets are sorted by asset class, exchange and symbol.
     * @param status e.g. “active”. By default, all statuses are included. (optional)
     * @param assetClass Defaults to us_equity. (optional)
     * @param exchange Optional AMEX, ARCA, BATS, NYSE, NASDAQ, NYSEARCA or OTC (optional)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;Assets&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Assets>> getV2AssetsWithHttpInfo(String status, String assetClass, String exchange, List<String> attributes) throws ApiException {
        okhttp3.Call localVarCall = getV2AssetsValidateBeforeCall(status, assetClass, exchange, attributes, null);
        Type localVarReturnType = new TypeToken<List<Assets>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Assets (asynchronously)
     * The assets API serves as the master list of assets available for trade and data consumption from Alpaca. Assets are sorted by asset class, exchange and symbol.
     * @param status e.g. “active”. By default, all statuses are included. (optional)
     * @param assetClass Defaults to us_equity. (optional)
     * @param exchange Optional AMEX, ARCA, BATS, NYSE, NASDAQ, NYSEARCA or OTC (optional)
     * @param attributes Comma separated values to query for more than one attribute. Assets which have any of the given attributes will be included. Supported values are &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, &#x60;options_enabled&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An array of asset objects </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2AssetsAsync(String status, String assetClass, String exchange, List<String> attributes, final ApiCallback<List<Assets>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV2AssetsValidateBeforeCall(status, assetClass, exchange, attributes, _callback);
        Type localVarReturnType = new TypeToken<List<Assets>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV2AssetsSymbolOrAssetId
     * @param symbolOrAssetId symbol or assetId (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Asset object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2AssetsSymbolOrAssetIdCall(String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/assets/{symbol_or_asset_id}"
            .replace("{" + "symbol_or_asset_id" + "}", localVarApiClient.escapeString(symbolOrAssetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV2AssetsSymbolOrAssetIdValidateBeforeCall(String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'symbolOrAssetId' is set
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling getV2AssetsSymbolOrAssetId(Async)");
        }

        return getV2AssetsSymbolOrAssetIdCall(symbolOrAssetId, _callback);

    }

    /**
     * Get an Asset by ID or Symbol
     * Get the asset model for a given symbol or asset_id. The symbol or asset_id should be passed in as a path parameter.  **Note**: For crypto, the symbol has to follow old symbology, e.g. BTCUSD.  **Note**: For coin pairs, the symbol should be separated by spare symbol (/), e.g. BTC/USDT. Since spare is a special character in HTTP, use the URL encoded version instead, e.g. /v2/assets/BTC%2FUSDT
     * @param symbolOrAssetId symbol or assetId (required)
     * @return Assets
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Asset object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Assets getV2AssetsSymbolOrAssetId(String symbolOrAssetId) throws ApiException {
        ApiResponse<Assets> localVarResp = getV2AssetsSymbolOrAssetIdWithHttpInfo(symbolOrAssetId);
        return localVarResp.getData();
    }

    /**
     * Get an Asset by ID or Symbol
     * Get the asset model for a given symbol or asset_id. The symbol or asset_id should be passed in as a path parameter.  **Note**: For crypto, the symbol has to follow old symbology, e.g. BTCUSD.  **Note**: For coin pairs, the symbol should be separated by spare symbol (/), e.g. BTC/USDT. Since spare is a special character in HTTP, use the URL encoded version instead, e.g. /v2/assets/BTC%2FUSDT
     * @param symbolOrAssetId symbol or assetId (required)
     * @return ApiResponse&lt;Assets&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Asset object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Assets> getV2AssetsSymbolOrAssetIdWithHttpInfo(String symbolOrAssetId) throws ApiException {
        okhttp3.Call localVarCall = getV2AssetsSymbolOrAssetIdValidateBeforeCall(symbolOrAssetId, null);
        Type localVarReturnType = new TypeToken<Assets>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an Asset by ID or Symbol (asynchronously)
     * Get the asset model for a given symbol or asset_id. The symbol or asset_id should be passed in as a path parameter.  **Note**: For crypto, the symbol has to follow old symbology, e.g. BTCUSD.  **Note**: For coin pairs, the symbol should be separated by spare symbol (/), e.g. BTC/USDT. Since spare is a special character in HTTP, use the URL encoded version instead, e.g. /v2/assets/BTC%2FUSDT
     * @param symbolOrAssetId symbol or assetId (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An Asset object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV2AssetsSymbolOrAssetIdAsync(String symbolOrAssetId, final ApiCallback<Assets> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV2AssetsSymbolOrAssetIdValidateBeforeCall(symbolOrAssetId, _callback);
        Type localVarReturnType = new TypeToken<Assets>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
