/*
 * Trading API
 * Alpaca's Trading API is a modern platform for algorithmic trading.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.trader.api;

import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.trader.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.trader.model.GetAccountActivities200ResponseInner;
import net.jacobpeterson.alpaca.openapi.trader.model.GetAccountActivitiesByActivityType200ResponseInner;
import java.time.OffsetDateTime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountActivitiesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountActivitiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountActivitiesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getAccountActivities
     * @param activityTypes A comma-separated list of the activity types to include in the response. If unspecified, activities of all types will be returned. (Cannot be used with category) (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesCall(String activityTypes, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/account/activities";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (activityTypes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activity_types", activityTypes));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountActivitiesValidateBeforeCall(String activityTypes, final ApiCallback _callback) throws ApiException {
        return getAccountActivitiesCall(activityTypes, _callback);

    }

    /**
     * Get Account Activities of Multiple Types
     * Returns account activity entries for many types of activities.
     * @param activityTypes A comma-separated list of the activity types to include in the response. If unspecified, activities of all types will be returned. (Cannot be used with category) (optional)
     * @return List&lt;GetAccountActivities200ResponseInner&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    public List<GetAccountActivities200ResponseInner> getAccountActivities(String activityTypes) throws ApiException {
        ApiResponse<List<GetAccountActivities200ResponseInner>> localVarResp = getAccountActivitiesWithHttpInfo(activityTypes);
        return localVarResp.getData();
    }

    /**
     * Get Account Activities of Multiple Types
     * Returns account activity entries for many types of activities.
     * @param activityTypes A comma-separated list of the activity types to include in the response. If unspecified, activities of all types will be returned. (Cannot be used with category) (optional)
     * @return ApiResponse&lt;List&lt;GetAccountActivities200ResponseInner&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<GetAccountActivities200ResponseInner>> getAccountActivitiesWithHttpInfo(String activityTypes) throws ApiException {
        okhttp3.Call localVarCall = getAccountActivitiesValidateBeforeCall(activityTypes, null);
        Type localVarReturnType = new TypeToken<List<GetAccountActivities200ResponseInner>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Account Activities of Multiple Types (asynchronously)
     * Returns account activity entries for many types of activities.
     * @param activityTypes A comma-separated list of the activity types to include in the response. If unspecified, activities of all types will be returned. (Cannot be used with category) (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesAsync(String activityTypes, final ApiCallback<List<GetAccountActivities200ResponseInner>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountActivitiesValidateBeforeCall(activityTypes, _callback);
        Type localVarReturnType = new TypeToken<List<GetAccountActivities200ResponseInner>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountActivitiesByActivityType
     * @param activityType The activity type you want to view entries for. A list of valid activity types can be found at the bottom of this page. (required)
     * @param date The date for which you want to see activities. (optional)
     * @param until The response will contain only activities submitted before this date. (Cannot be used with date.) (optional)
     * @param after The response will contain only activities submitted after this date. (Cannot be used with date.) (optional)
     * @param direction asc or desc (default desc if unspecified.) (optional)
     * @param pageSize The maximum number of entries to return in the response. (See the section on paging above.) (optional)
     * @param pageToken The ID of the end of your current page of results.  (optional)
     * @param category trade_activity or non_trade_activity, to specify the kind of results the server should return. (Cannot be used with /{activity_type} or ?activity_types&#x3D;...) (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesByActivityTypeCall(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/account/activities/{activity_type}"
            .replace("{" + "activity_type" + "}", localVarApiClient.escapeString(activityType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (date != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date", date));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (direction != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("direction", direction));
        }

        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_size", pageSize));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "API_Key", "API_Secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountActivitiesByActivityTypeValidateBeforeCall(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'activityType' is set
        if (activityType == null) {
            throw new ApiException("Missing the required parameter 'activityType' when calling getAccountActivitiesByActivityType(Async)");
        }

        return getAccountActivitiesByActivityTypeCall(activityType, date, until, after, direction, pageSize, pageToken, category, _callback);

    }

    /**
     * Get Account Activities of One Type
     * Returns account activity entries for a specific type of activity.
     * @param activityType The activity type you want to view entries for. A list of valid activity types can be found at the bottom of this page. (required)
     * @param date The date for which you want to see activities. (optional)
     * @param until The response will contain only activities submitted before this date. (Cannot be used with date.) (optional)
     * @param after The response will contain only activities submitted after this date. (Cannot be used with date.) (optional)
     * @param direction asc or desc (default desc if unspecified.) (optional)
     * @param pageSize The maximum number of entries to return in the response. (See the section on paging above.) (optional)
     * @param pageToken The ID of the end of your current page of results.  (optional)
     * @param category trade_activity or non_trade_activity, to specify the kind of results the server should return. (Cannot be used with /{activity_type} or ?activity_types&#x3D;...) (optional)
     * @return List&lt;GetAccountActivitiesByActivityType200ResponseInner&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    public List<GetAccountActivitiesByActivityType200ResponseInner> getAccountActivitiesByActivityType(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        ApiResponse<List<GetAccountActivitiesByActivityType200ResponseInner>> localVarResp = getAccountActivitiesByActivityTypeWithHttpInfo(activityType, date, until, after, direction, pageSize, pageToken, category);
        return localVarResp.getData();
    }

    /**
     * Get Account Activities of One Type
     * Returns account activity entries for a specific type of activity.
     * @param activityType The activity type you want to view entries for. A list of valid activity types can be found at the bottom of this page. (required)
     * @param date The date for which you want to see activities. (optional)
     * @param until The response will contain only activities submitted before this date. (Cannot be used with date.) (optional)
     * @param after The response will contain only activities submitted after this date. (Cannot be used with date.) (optional)
     * @param direction asc or desc (default desc if unspecified.) (optional)
     * @param pageSize The maximum number of entries to return in the response. (See the section on paging above.) (optional)
     * @param pageToken The ID of the end of your current page of results.  (optional)
     * @param category trade_activity or non_trade_activity, to specify the kind of results the server should return. (Cannot be used with /{activity_type} or ?activity_types&#x3D;...) (optional)
     * @return ApiResponse&lt;List&lt;GetAccountActivitiesByActivityType200ResponseInner&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<GetAccountActivitiesByActivityType200ResponseInner>> getAccountActivitiesByActivityTypeWithHttpInfo(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category) throws ApiException {
        okhttp3.Call localVarCall = getAccountActivitiesByActivityTypeValidateBeforeCall(activityType, date, until, after, direction, pageSize, pageToken, category, null);
        Type localVarReturnType = new TypeToken<List<GetAccountActivitiesByActivityType200ResponseInner>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Account Activities of One Type (asynchronously)
     * Returns account activity entries for a specific type of activity.
     * @param activityType The activity type you want to view entries for. A list of valid activity types can be found at the bottom of this page. (required)
     * @param date The date for which you want to see activities. (optional)
     * @param until The response will contain only activities submitted before this date. (Cannot be used with date.) (optional)
     * @param after The response will contain only activities submitted after this date. (Cannot be used with date.) (optional)
     * @param direction asc or desc (default desc if unspecified.) (optional)
     * @param pageSize The maximum number of entries to return in the response. (See the section on paging above.) (optional)
     * @param pageToken The ID of the end of your current page of results.  (optional)
     * @param category trade_activity or non_trade_activity, to specify the kind of results the server should return. (Cannot be used with /{activity_type} or ?activity_types&#x3D;...) (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns an array of Account activities </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAccountActivitiesByActivityTypeAsync(String activityType, OffsetDateTime date, OffsetDateTime until, OffsetDateTime after, String direction, Integer pageSize, String pageToken, String category, final ApiCallback<List<GetAccountActivitiesByActivityType200ResponseInner>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountActivitiesByActivityTypeValidateBeforeCall(activityType, date, until, after, direction, pageSize, pageToken, category, _callback);
        Type localVarReturnType = new TypeToken<List<GetAccountActivitiesByActivityType200ResponseInner>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
