/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTape;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * A stock trade
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class StockTrade {
  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public static final String SERIALIZED_NAME_X = "x";
  @SerializedName(SERIALIZED_NAME_X)
  private String x;

  public static final String SERIALIZED_NAME_P = "p";
  @SerializedName(SERIALIZED_NAME_P)
  private Double p;

  public static final String SERIALIZED_NAME_S = "s";
  @SerializedName(SERIALIZED_NAME_S)
  private Integer s;

  public static final String SERIALIZED_NAME_I = "i";
  @SerializedName(SERIALIZED_NAME_I)
  private Integer i;

  public static final String SERIALIZED_NAME_C = "c";
  @SerializedName(SERIALIZED_NAME_C)
  private List<String> c = new ArrayList<>();

  public static final String SERIALIZED_NAME_Z = "z";
  @SerializedName(SERIALIZED_NAME_Z)
  private StockTape z;

  public StockTrade() {
  }

  public StockTrade t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp in RFC-3339 format with nanosecond precision
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }


  public StockTrade x(String x) {
    this.x = x;
    return this;
  }

   /**
   * Exchange code. See &#x60;v2/stocks/meta/exchanges&#x60; for more details.
   * @return x
  **/
  @javax.annotation.Nonnull
  public String getX() {
    return x;
  }

  public void setX(String x) {
    this.x = x;
  }


  public StockTrade p(Double p) {
    this.p = p;
    return this;
  }

   /**
   * Trade price
   * @return p
  **/
  @javax.annotation.Nonnull
  public Double getP() {
    return p;
  }

  public void setP(Double p) {
    this.p = p;
  }


  public StockTrade s(Integer s) {
    this.s = s;
    return this;
  }

   /**
   * Trade size
   * @return s
  **/
  @javax.annotation.Nonnull
  public Integer getS() {
    return s;
  }

  public void setS(Integer s) {
    this.s = s;
  }


  public StockTrade i(Integer i) {
    this.i = i;
    return this;
  }

   /**
   * Trade ID sent by the exchange
   * @return i
  **/
  @javax.annotation.Nonnull
  public Integer getI() {
    return i;
  }

  public void setI(Integer i) {
    this.i = i;
  }


  public StockTrade c(List<String> c) {
    this.c = c;
    return this;
  }

  public StockTrade addCItem(String cItem) {
    if (this.c == null) {
      this.c = new ArrayList<>();
    }
    this.c.add(cItem);
    return this;
  }

   /**
   * Condition flags. See &#x60;v2/stocks/meta/conditions/trade&#x60; for more details.
   * @return c
  **/
  @javax.annotation.Nonnull
  public List<String> getC() {
    return c;
  }

  public void setC(List<String> c) {
    this.c = c;
  }


  public StockTrade z(StockTape z) {
    this.z = z;
    return this;
  }

   /**
   * Get z
   * @return z
  **/
  @javax.annotation.Nonnull
  public StockTape getZ() {
    return z;
  }

  public void setZ(StockTape z) {
    this.z = z;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StockTrade stockTrade = (StockTrade) o;
    return Objects.equals(this.t, stockTrade.t) &&
        Objects.equals(this.x, stockTrade.x) &&
        Objects.equals(this.p, stockTrade.p) &&
        Objects.equals(this.s, stockTrade.s) &&
        Objects.equals(this.i, stockTrade.i) &&
        Objects.equals(this.c, stockTrade.c) &&
        Objects.equals(this.z, stockTrade.z);
  }

  @Override
  public int hashCode() {
    return Objects.hash(t, x, p, s, i, c, z);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StockTrade {\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("    x: ").append(toIndentedString(x)).append("\n");
    sb.append("    p: ").append(toIndentedString(p)).append("\n");
    sb.append("    s: ").append(toIndentedString(s)).append("\n");
    sb.append("    i: ").append(toIndentedString(i)).append("\n");
    sb.append("    c: ").append(toIndentedString(c)).append("\n");
    sb.append("    z: ").append(toIndentedString(z)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("t");
    openapiFields.add("x");
    openapiFields.add("p");
    openapiFields.add("s");
    openapiFields.add("i");
    openapiFields.add("c");
    openapiFields.add("z");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("t");
    openapiRequiredFields.add("x");
    openapiRequiredFields.add("p");
    openapiRequiredFields.add("s");
    openapiRequiredFields.add("i");
    openapiRequiredFields.add("c");
    openapiRequiredFields.add("z");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!StockTrade.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in StockTrade is not found in the empty JSON string", StockTrade.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!StockTrade.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockTrade` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : StockTrade.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("x").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `x` to be a primitive type in the JSON string but got `%s`", jsonObj.get("x").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("c") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("c").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `c` to be an array in the JSON string but got `%s`", jsonObj.get("c").toString()));
      }
      // validate the required field `z`
      StockTape.validateJsonElement(jsonObj.get("z"));
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!StockTrade.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'StockTrade' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<StockTrade> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(StockTrade.class));

       return (TypeAdapter<T>) new TypeAdapter<StockTrade>() {
           @Override
           public void write(JsonWriter out, StockTrade value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public StockTrade read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of StockTrade given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of StockTrade
  * @throws IOException if the JSON string is invalid with respect to StockTrade
  */
  public static StockTrade fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, StockTrade.class);
  }

 /**
  * Convert an instance of StockTrade to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

