/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockBar;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockQuote;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * A snapshot provides the latest trade, latest quote, latest minute bar, current daily bar and previous daily bar. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class StockSnapshot {
  public static final String SERIALIZED_NAME_DAILY_BAR = "dailyBar";
  @SerializedName(SERIALIZED_NAME_DAILY_BAR)
  private StockBar dailyBar;

  public static final String SERIALIZED_NAME_LATEST_QUOTE = "latestQuote";
  @SerializedName(SERIALIZED_NAME_LATEST_QUOTE)
  private StockQuote latestQuote;

  public static final String SERIALIZED_NAME_LATEST_TRADE = "latestTrade";
  @SerializedName(SERIALIZED_NAME_LATEST_TRADE)
  private StockTrade latestTrade;

  public static final String SERIALIZED_NAME_MINUTE_BAR = "minuteBar";
  @SerializedName(SERIALIZED_NAME_MINUTE_BAR)
  private StockBar minuteBar;

  public static final String SERIALIZED_NAME_PREV_DAILY_BAR = "prevDailyBar";
  @SerializedName(SERIALIZED_NAME_PREV_DAILY_BAR)
  private StockBar prevDailyBar;

  public StockSnapshot() {
  }

  public StockSnapshot dailyBar(StockBar dailyBar) {
    this.dailyBar = dailyBar;
    return this;
  }

   /**
   * Get dailyBar
   * @return dailyBar
  **/
  @javax.annotation.Nullable
  public StockBar getDailyBar() {
    return dailyBar;
  }

  public void setDailyBar(StockBar dailyBar) {
    this.dailyBar = dailyBar;
  }


  public StockSnapshot latestQuote(StockQuote latestQuote) {
    this.latestQuote = latestQuote;
    return this;
  }

   /**
   * Get latestQuote
   * @return latestQuote
  **/
  @javax.annotation.Nullable
  public StockQuote getLatestQuote() {
    return latestQuote;
  }

  public void setLatestQuote(StockQuote latestQuote) {
    this.latestQuote = latestQuote;
  }


  public StockSnapshot latestTrade(StockTrade latestTrade) {
    this.latestTrade = latestTrade;
    return this;
  }

   /**
   * Get latestTrade
   * @return latestTrade
  **/
  @javax.annotation.Nullable
  public StockTrade getLatestTrade() {
    return latestTrade;
  }

  public void setLatestTrade(StockTrade latestTrade) {
    this.latestTrade = latestTrade;
  }


  public StockSnapshot minuteBar(StockBar minuteBar) {
    this.minuteBar = minuteBar;
    return this;
  }

   /**
   * Get minuteBar
   * @return minuteBar
  **/
  @javax.annotation.Nullable
  public StockBar getMinuteBar() {
    return minuteBar;
  }

  public void setMinuteBar(StockBar minuteBar) {
    this.minuteBar = minuteBar;
  }


  public StockSnapshot prevDailyBar(StockBar prevDailyBar) {
    this.prevDailyBar = prevDailyBar;
    return this;
  }

   /**
   * Get prevDailyBar
   * @return prevDailyBar
  **/
  @javax.annotation.Nullable
  public StockBar getPrevDailyBar() {
    return prevDailyBar;
  }

  public void setPrevDailyBar(StockBar prevDailyBar) {
    this.prevDailyBar = prevDailyBar;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StockSnapshot stockSnapshot = (StockSnapshot) o;
    return Objects.equals(this.dailyBar, stockSnapshot.dailyBar) &&
        Objects.equals(this.latestQuote, stockSnapshot.latestQuote) &&
        Objects.equals(this.latestTrade, stockSnapshot.latestTrade) &&
        Objects.equals(this.minuteBar, stockSnapshot.minuteBar) &&
        Objects.equals(this.prevDailyBar, stockSnapshot.prevDailyBar);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dailyBar, latestQuote, latestTrade, minuteBar, prevDailyBar);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StockSnapshot {\n");
    sb.append("    dailyBar: ").append(toIndentedString(dailyBar)).append("\n");
    sb.append("    latestQuote: ").append(toIndentedString(latestQuote)).append("\n");
    sb.append("    latestTrade: ").append(toIndentedString(latestTrade)).append("\n");
    sb.append("    minuteBar: ").append(toIndentedString(minuteBar)).append("\n");
    sb.append("    prevDailyBar: ").append(toIndentedString(prevDailyBar)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("dailyBar");
    openapiFields.add("latestQuote");
    openapiFields.add("latestTrade");
    openapiFields.add("minuteBar");
    openapiFields.add("prevDailyBar");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!StockSnapshot.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in StockSnapshot is not found in the empty JSON string", StockSnapshot.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!StockSnapshot.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockSnapshot` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `dailyBar`
      if (jsonObj.get("dailyBar") != null && !jsonObj.get("dailyBar").isJsonNull()) {
        StockBar.validateJsonElement(jsonObj.get("dailyBar"));
      }
      // validate the optional field `latestQuote`
      if (jsonObj.get("latestQuote") != null && !jsonObj.get("latestQuote").isJsonNull()) {
        StockQuote.validateJsonElement(jsonObj.get("latestQuote"));
      }
      // validate the optional field `latestTrade`
      if (jsonObj.get("latestTrade") != null && !jsonObj.get("latestTrade").isJsonNull()) {
        StockTrade.validateJsonElement(jsonObj.get("latestTrade"));
      }
      // validate the optional field `minuteBar`
      if (jsonObj.get("minuteBar") != null && !jsonObj.get("minuteBar").isJsonNull()) {
        StockBar.validateJsonElement(jsonObj.get("minuteBar"));
      }
      // validate the optional field `prevDailyBar`
      if (jsonObj.get("prevDailyBar") != null && !jsonObj.get("prevDailyBar").isJsonNull()) {
        StockBar.validateJsonElement(jsonObj.get("prevDailyBar"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!StockSnapshot.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'StockSnapshot' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<StockSnapshot> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(StockSnapshot.class));

       return (TypeAdapter<T>) new TypeAdapter<StockSnapshot>() {
           @Override
           public void write(JsonWriter out, StockSnapshot value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public StockSnapshot read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of StockSnapshot given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of StockSnapshot
  * @throws IOException if the JSON string is invalid with respect to StockSnapshot
  */
  public static StockSnapshot fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, StockSnapshot.class);
  }

 /**
  * Convert an instance of StockSnapshot to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

