/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockTape;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * The best bid and ask information for a given security. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class StockQuote {
  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public static final String SERIALIZED_NAME_BX = "bx";
  @SerializedName(SERIALIZED_NAME_BX)
  private String bx;

  public static final String SERIALIZED_NAME_BP = "bp";
  @SerializedName(SERIALIZED_NAME_BP)
  private Double bp;

  public static final String SERIALIZED_NAME_BS = "bs";
  @SerializedName(SERIALIZED_NAME_BS)
  private Integer bs;

  public static final String SERIALIZED_NAME_AX = "ax";
  @SerializedName(SERIALIZED_NAME_AX)
  private String ax;

  public static final String SERIALIZED_NAME_AP = "ap";
  @SerializedName(SERIALIZED_NAME_AP)
  private Double ap;

  public static final String SERIALIZED_NAME_AS = "as";
  @SerializedName(SERIALIZED_NAME_AS)
  private Integer as;

  public static final String SERIALIZED_NAME_C = "c";
  @SerializedName(SERIALIZED_NAME_C)
  private List<String> c = new ArrayList<>();

  public static final String SERIALIZED_NAME_Z = "z";
  @SerializedName(SERIALIZED_NAME_Z)
  private StockTape z;

  public StockQuote() {
  }

  public StockQuote t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp in RFC-3339 format with nanosecond precision
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }


  public StockQuote bx(String bx) {
    this.bx = bx;
    return this;
  }

   /**
   * Bid exchange. See &#x60;v2/stocks/meta/exchanges&#x60; for more details.
   * @return bx
  **/
  @javax.annotation.Nonnull
  public String getBx() {
    return bx;
  }

  public void setBx(String bx) {
    this.bx = bx;
  }


  public StockQuote bp(Double bp) {
    this.bp = bp;
    return this;
  }

   /**
   * Bid price. 0 means the security has no active bid.
   * @return bp
  **/
  @javax.annotation.Nonnull
  public Double getBp() {
    return bp;
  }

  public void setBp(Double bp) {
    this.bp = bp;
  }


  public StockQuote bs(Integer bs) {
    this.bs = bs;
    return this;
  }

   /**
   * Bid size
   * @return bs
  **/
  @javax.annotation.Nonnull
  public Integer getBs() {
    return bs;
  }

  public void setBs(Integer bs) {
    this.bs = bs;
  }


  public StockQuote ax(String ax) {
    this.ax = ax;
    return this;
  }

   /**
   * Ask exchange. See &#x60;v2/stocks/meta/exchanges&#x60; for more details.
   * @return ax
  **/
  @javax.annotation.Nonnull
  public String getAx() {
    return ax;
  }

  public void setAx(String ax) {
    this.ax = ax;
  }


  public StockQuote ap(Double ap) {
    this.ap = ap;
    return this;
  }

   /**
   * Ask price. 0 means the security has no active ask.
   * @return ap
  **/
  @javax.annotation.Nonnull
  public Double getAp() {
    return ap;
  }

  public void setAp(Double ap) {
    this.ap = ap;
  }


  public StockQuote as(Integer as) {
    this.as = as;
    return this;
  }

   /**
   * Ask size
   * @return as
  **/
  @javax.annotation.Nonnull
  public Integer getAs() {
    return as;
  }

  public void setAs(Integer as) {
    this.as = as;
  }


  public StockQuote c(List<String> c) {
    this.c = c;
    return this;
  }

  public StockQuote addCItem(String cItem) {
    if (this.c == null) {
      this.c = new ArrayList<>();
    }
    this.c.add(cItem);
    return this;
  }

   /**
   * Condition flags. See &#x60;v2/stocks/meta/conditions/quote&#x60; for more details. If the array contains one flag, it applies to both the bid and ask. If the array contains two flags, the first one applies to the bid and the second one to the ask. 
   * @return c
  **/
  @javax.annotation.Nonnull
  public List<String> getC() {
    return c;
  }

  public void setC(List<String> c) {
    this.c = c;
  }


  public StockQuote z(StockTape z) {
    this.z = z;
    return this;
  }

   /**
   * Get z
   * @return z
  **/
  @javax.annotation.Nonnull
  public StockTape getZ() {
    return z;
  }

  public void setZ(StockTape z) {
    this.z = z;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StockQuote stockQuote = (StockQuote) o;
    return Objects.equals(this.t, stockQuote.t) &&
        Objects.equals(this.bx, stockQuote.bx) &&
        Objects.equals(this.bp, stockQuote.bp) &&
        Objects.equals(this.bs, stockQuote.bs) &&
        Objects.equals(this.ax, stockQuote.ax) &&
        Objects.equals(this.ap, stockQuote.ap) &&
        Objects.equals(this.as, stockQuote.as) &&
        Objects.equals(this.c, stockQuote.c) &&
        Objects.equals(this.z, stockQuote.z);
  }

  @Override
  public int hashCode() {
    return Objects.hash(t, bx, bp, bs, ax, ap, as, c, z);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StockQuote {\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("    bx: ").append(toIndentedString(bx)).append("\n");
    sb.append("    bp: ").append(toIndentedString(bp)).append("\n");
    sb.append("    bs: ").append(toIndentedString(bs)).append("\n");
    sb.append("    ax: ").append(toIndentedString(ax)).append("\n");
    sb.append("    ap: ").append(toIndentedString(ap)).append("\n");
    sb.append("    as: ").append(toIndentedString(as)).append("\n");
    sb.append("    c: ").append(toIndentedString(c)).append("\n");
    sb.append("    z: ").append(toIndentedString(z)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("t");
    openapiFields.add("bx");
    openapiFields.add("bp");
    openapiFields.add("bs");
    openapiFields.add("ax");
    openapiFields.add("ap");
    openapiFields.add("as");
    openapiFields.add("c");
    openapiFields.add("z");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("t");
    openapiRequiredFields.add("bx");
    openapiRequiredFields.add("bp");
    openapiRequiredFields.add("bs");
    openapiRequiredFields.add("ax");
    openapiRequiredFields.add("ap");
    openapiRequiredFields.add("as");
    openapiRequiredFields.add("c");
    openapiRequiredFields.add("z");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!StockQuote.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in StockQuote is not found in the empty JSON string", StockQuote.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!StockQuote.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockQuote` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : StockQuote.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("bx").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bx` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bx").toString()));
      }
      if (!jsonObj.get("ax").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ax` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ax").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("c") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("c").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `c` to be an array in the JSON string but got `%s`", jsonObj.get("c").toString()));
      }
      // validate the required field `z`
      StockTape.validateJsonElement(jsonObj.get("z"));
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!StockQuote.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'StockQuote' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<StockQuote> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(StockQuote.class));

       return (TypeAdapter<T>) new TypeAdapter<StockQuote>() {
           @Override
           public void write(JsonWriter out, StockQuote value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public StockQuote read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of StockQuote given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of StockQuote
  * @throws IOException if the JSON string is invalid with respect to StockQuote
  */
  public static StockQuote fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, StockQuote.class);
  }

 /**
  * Convert an instance of StockQuote to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

