/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.marketdata.model.StockAuction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Opening and closing auction prices for a given day. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class StockDailyAuctions {
  public static final String SERIALIZED_NAME_D = "d";
  @SerializedName(SERIALIZED_NAME_D)
  private LocalDate d;

  public static final String SERIALIZED_NAME_O = "o";
  @SerializedName(SERIALIZED_NAME_O)
  private List<StockAuction> o = new ArrayList<>();

  public static final String SERIALIZED_NAME_C = "c";
  @SerializedName(SERIALIZED_NAME_C)
  private List<StockAuction> c = new ArrayList<>();

  public StockDailyAuctions() {
  }

  public StockDailyAuctions d(LocalDate d) {
    this.d = d;
    return this;
  }

   /**
   * Date in RFC-3339
   * @return d
  **/
  @javax.annotation.Nonnull
  public LocalDate getD() {
    return d;
  }

  public void setD(LocalDate d) {
    this.d = d;
  }


  public StockDailyAuctions o(List<StockAuction> o) {
    this.o = o;
    return this;
  }

  public StockDailyAuctions addOItem(StockAuction oItem) {
    if (this.o == null) {
      this.o = new ArrayList<>();
    }
    this.o.add(oItem);
    return this;
  }

   /**
   * Opening auctions.
   * @return o
  **/
  @javax.annotation.Nonnull
  public List<StockAuction> getO() {
    return o;
  }

  public void setO(List<StockAuction> o) {
    this.o = o;
  }


  public StockDailyAuctions c(List<StockAuction> c) {
    this.c = c;
    return this;
  }

  public StockDailyAuctions addCItem(StockAuction cItem) {
    if (this.c == null) {
      this.c = new ArrayList<>();
    }
    this.c.add(cItem);
    return this;
  }

   /**
   * Closing auctions. Every price / exchange / condition triplet is only shown once, with its earliest timestamp.
   * @return c
  **/
  @javax.annotation.Nonnull
  public List<StockAuction> getC() {
    return c;
  }

  public void setC(List<StockAuction> c) {
    this.c = c;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StockDailyAuctions stockDailyAuctions = (StockDailyAuctions) o;
    return Objects.equals(this.d, stockDailyAuctions.d) &&
        Objects.equals(this.o, stockDailyAuctions.o) &&
        Objects.equals(this.c, stockDailyAuctions.c);
  }

  @Override
  public int hashCode() {
    return Objects.hash(d, o, c);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StockDailyAuctions {\n");
    sb.append("    d: ").append(toIndentedString(d)).append("\n");
    sb.append("    o: ").append(toIndentedString(o)).append("\n");
    sb.append("    c: ").append(toIndentedString(c)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("d");
    openapiFields.add("o");
    openapiFields.add("c");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("d");
    openapiRequiredFields.add("o");
    openapiRequiredFields.add("c");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!StockDailyAuctions.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in StockDailyAuctions is not found in the empty JSON string", StockDailyAuctions.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!StockDailyAuctions.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockDailyAuctions` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : StockDailyAuctions.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the json data is an array
      if (!jsonObj.get("o").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `o` to be an array in the JSON string but got `%s`", jsonObj.get("o").toString()));
      }

      JsonArray jsonArrayo = jsonObj.getAsJsonArray("o");
      // validate the required field `o` (array)
      for (int i = 0; i < jsonArrayo.size(); i++) {
        StockAuction.validateJsonElement(jsonArrayo.get(i));
      };
      // ensure the json data is an array
      if (!jsonObj.get("c").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `c` to be an array in the JSON string but got `%s`", jsonObj.get("c").toString()));
      }

      JsonArray jsonArrayc = jsonObj.getAsJsonArray("c");
      // validate the required field `c` (array)
      for (int i = 0; i < jsonArrayc.size(); i++) {
        StockAuction.validateJsonElement(jsonArrayc.get(i));
      };
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!StockDailyAuctions.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'StockDailyAuctions' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<StockDailyAuctions> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(StockDailyAuctions.class));

       return (TypeAdapter<T>) new TypeAdapter<StockDailyAuctions>() {
           @Override
           public void write(JsonWriter out, StockDailyAuctions value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public StockDailyAuctions read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of StockDailyAuctions given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of StockDailyAuctions
  * @throws IOException if the JSON string is invalid with respect to StockDailyAuctions
  */
  public static StockDailyAuctions fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, StockDailyAuctions.class);
  }

 /**
  * Convert an instance of StockDailyAuctions to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

