/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets StockAdjustment
 */
@JsonAdapter(StockAdjustment.Adapter.class)
public enum StockAdjustment {
  
  RAW("raw"),
  
  SPLIT("split"),
  
  DIVIDEND("dividend"),
  
  ALL("all");

  private String value;

  StockAdjustment(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static StockAdjustment fromValue(String value) {
    for (StockAdjustment b : StockAdjustment.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<StockAdjustment> {
    @Override
    public void write(final JsonWriter jsonWriter, final StockAdjustment enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public StockAdjustment read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return StockAdjustment.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    StockAdjustment.fromValue(value);
  }
}

