/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMarketType;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMover;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Contains list of market movers
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class ScreenerMoversResp {
  public static final String SERIALIZED_NAME_GAINERS = "gainers";
  @SerializedName(SERIALIZED_NAME_GAINERS)
  private List<ScreenerMover> gainers = new ArrayList<>();

  public static final String SERIALIZED_NAME_LOSERS = "losers";
  @SerializedName(SERIALIZED_NAME_LOSERS)
  private List<ScreenerMover> losers = new ArrayList<>();

  public static final String SERIALIZED_NAME_MARKET_TYPE = "market_type";
  @SerializedName(SERIALIZED_NAME_MARKET_TYPE)
  private ScreenerMarketType marketType;

  public static final String SERIALIZED_NAME_LAST_UPDATED = "last_updated";
  @SerializedName(SERIALIZED_NAME_LAST_UPDATED)
  private String lastUpdated;

  public ScreenerMoversResp() {
  }

  public ScreenerMoversResp gainers(List<ScreenerMover> gainers) {
    this.gainers = gainers;
    return this;
  }

  public ScreenerMoversResp addGainersItem(ScreenerMover gainersItem) {
    if (this.gainers == null) {
      this.gainers = new ArrayList<>();
    }
    this.gainers.add(gainersItem);
    return this;
  }

   /**
   * List of top N gainers.
   * @return gainers
  **/
  @javax.annotation.Nonnull
  public List<ScreenerMover> getGainers() {
    return gainers;
  }

  public void setGainers(List<ScreenerMover> gainers) {
    this.gainers = gainers;
  }


  public ScreenerMoversResp losers(List<ScreenerMover> losers) {
    this.losers = losers;
    return this;
  }

  public ScreenerMoversResp addLosersItem(ScreenerMover losersItem) {
    if (this.losers == null) {
      this.losers = new ArrayList<>();
    }
    this.losers.add(losersItem);
    return this;
  }

   /**
   * List of top N losers.
   * @return losers
  **/
  @javax.annotation.Nonnull
  public List<ScreenerMover> getLosers() {
    return losers;
  }

  public void setLosers(List<ScreenerMover> losers) {
    this.losers = losers;
  }


  public ScreenerMoversResp marketType(ScreenerMarketType marketType) {
    this.marketType = marketType;
    return this;
  }

   /**
   * Get marketType
   * @return marketType
  **/
  @javax.annotation.Nonnull
  public ScreenerMarketType getMarketType() {
    return marketType;
  }

  public void setMarketType(ScreenerMarketType marketType) {
    this.marketType = marketType;
  }


  public ScreenerMoversResp lastUpdated(String lastUpdated) {
    this.lastUpdated = lastUpdated;
    return this;
  }

   /**
   * Time when the movers were last computed. Formatted as a RFC 3339 formatted datetime  with nanosecond precision. 
   * @return lastUpdated
  **/
  @javax.annotation.Nonnull
  public String getLastUpdated() {
    return lastUpdated;
  }

  public void setLastUpdated(String lastUpdated) {
    this.lastUpdated = lastUpdated;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScreenerMoversResp screenerMoversResp = (ScreenerMoversResp) o;
    return Objects.equals(this.gainers, screenerMoversResp.gainers) &&
        Objects.equals(this.losers, screenerMoversResp.losers) &&
        Objects.equals(this.marketType, screenerMoversResp.marketType) &&
        Objects.equals(this.lastUpdated, screenerMoversResp.lastUpdated);
  }

  @Override
  public int hashCode() {
    return Objects.hash(gainers, losers, marketType, lastUpdated);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScreenerMoversResp {\n");
    sb.append("    gainers: ").append(toIndentedString(gainers)).append("\n");
    sb.append("    losers: ").append(toIndentedString(losers)).append("\n");
    sb.append("    marketType: ").append(toIndentedString(marketType)).append("\n");
    sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("gainers");
    openapiFields.add("losers");
    openapiFields.add("market_type");
    openapiFields.add("last_updated");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("gainers");
    openapiRequiredFields.add("losers");
    openapiRequiredFields.add("market_type");
    openapiRequiredFields.add("last_updated");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!ScreenerMoversResp.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ScreenerMoversResp is not found in the empty JSON string", ScreenerMoversResp.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!ScreenerMoversResp.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ScreenerMoversResp` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ScreenerMoversResp.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the json data is an array
      if (!jsonObj.get("gainers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `gainers` to be an array in the JSON string but got `%s`", jsonObj.get("gainers").toString()));
      }

      JsonArray jsonArraygainers = jsonObj.getAsJsonArray("gainers");
      // validate the required field `gainers` (array)
      for (int i = 0; i < jsonArraygainers.size(); i++) {
        ScreenerMover.validateJsonElement(jsonArraygainers.get(i));
      };
      // ensure the json data is an array
      if (!jsonObj.get("losers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `losers` to be an array in the JSON string but got `%s`", jsonObj.get("losers").toString()));
      }

      JsonArray jsonArraylosers = jsonObj.getAsJsonArray("losers");
      // validate the required field `losers` (array)
      for (int i = 0; i < jsonArraylosers.size(); i++) {
        ScreenerMover.validateJsonElement(jsonArraylosers.get(i));
      };
      // validate the required field `market_type`
      ScreenerMarketType.validateJsonElement(jsonObj.get("market_type"));
      if (!jsonObj.get("last_updated").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_updated` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_updated").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ScreenerMoversResp.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ScreenerMoversResp' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ScreenerMoversResp> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ScreenerMoversResp.class));

       return (TypeAdapter<T>) new TypeAdapter<ScreenerMoversResp>() {
           @Override
           public void write(JsonWriter out, ScreenerMoversResp value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ScreenerMoversResp read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ScreenerMoversResp given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ScreenerMoversResp
  * @throws IOException if the JSON string is invalid with respect to ScreenerMoversResp
  */
  public static ScreenerMoversResp fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ScreenerMoversResp.class);
  }

 /**
  * Convert an instance of ScreenerMoversResp to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

