/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.marketdata.model.ScreenerMostActive;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * ScreenerMostActivesResp
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class ScreenerMostActivesResp {
  public static final String SERIALIZED_NAME_MOST_ACTIVES = "most_actives";
  @SerializedName(SERIALIZED_NAME_MOST_ACTIVES)
  private List<ScreenerMostActive> mostActives = new ArrayList<>();

  public static final String SERIALIZED_NAME_LAST_UPDATED = "last_updated";
  @SerializedName(SERIALIZED_NAME_LAST_UPDATED)
  private String lastUpdated;

  public ScreenerMostActivesResp() {
  }

  public ScreenerMostActivesResp mostActives(List<ScreenerMostActive> mostActives) {
    this.mostActives = mostActives;
    return this;
  }

  public ScreenerMostActivesResp addMostActivesItem(ScreenerMostActive mostActivesItem) {
    if (this.mostActives == null) {
      this.mostActives = new ArrayList<>();
    }
    this.mostActives.add(mostActivesItem);
    return this;
  }

   /**
   * List of top N most active symbols.
   * @return mostActives
  **/
  @javax.annotation.Nonnull
  public List<ScreenerMostActive> getMostActives() {
    return mostActives;
  }

  public void setMostActives(List<ScreenerMostActive> mostActives) {
    this.mostActives = mostActives;
  }


  public ScreenerMostActivesResp lastUpdated(String lastUpdated) {
    this.lastUpdated = lastUpdated;
    return this;
  }

   /**
   * Time when the most actives were last computed. Formatted as a RFC 3339 formatted datetime with nanosecond precision. 
   * @return lastUpdated
  **/
  @javax.annotation.Nonnull
  public String getLastUpdated() {
    return lastUpdated;
  }

  public void setLastUpdated(String lastUpdated) {
    this.lastUpdated = lastUpdated;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScreenerMostActivesResp screenerMostActivesResp = (ScreenerMostActivesResp) o;
    return Objects.equals(this.mostActives, screenerMostActivesResp.mostActives) &&
        Objects.equals(this.lastUpdated, screenerMostActivesResp.lastUpdated);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mostActives, lastUpdated);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScreenerMostActivesResp {\n");
    sb.append("    mostActives: ").append(toIndentedString(mostActives)).append("\n");
    sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("most_actives");
    openapiFields.add("last_updated");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("most_actives");
    openapiRequiredFields.add("last_updated");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!ScreenerMostActivesResp.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ScreenerMostActivesResp is not found in the empty JSON string", ScreenerMostActivesResp.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!ScreenerMostActivesResp.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ScreenerMostActivesResp` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ScreenerMostActivesResp.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the json data is an array
      if (!jsonObj.get("most_actives").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `most_actives` to be an array in the JSON string but got `%s`", jsonObj.get("most_actives").toString()));
      }

      JsonArray jsonArraymostActives = jsonObj.getAsJsonArray("most_actives");
      // validate the required field `most_actives` (array)
      for (int i = 0; i < jsonArraymostActives.size(); i++) {
        ScreenerMostActive.validateJsonElement(jsonArraymostActives.get(i));
      };
      if (!jsonObj.get("last_updated").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_updated` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_updated").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ScreenerMostActivesResp.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ScreenerMostActivesResp' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ScreenerMostActivesResp> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ScreenerMostActivesResp.class));

       return (TypeAdapter<T>) new TypeAdapter<ScreenerMostActivesResp>() {
           @Override
           public void write(JsonWriter out, ScreenerMostActivesResp value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ScreenerMostActivesResp read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ScreenerMostActivesResp given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ScreenerMostActivesResp
  * @throws IOException if the JSON string is invalid with respect to ScreenerMostActivesResp
  */
  public static ScreenerMostActivesResp fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ScreenerMostActivesResp.class);
  }

 /**
  * Convert an instance of ScreenerMostActivesResp to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

