/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * An option trade
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class OptionTrade {
  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public static final String SERIALIZED_NAME_X = "x";
  @SerializedName(SERIALIZED_NAME_X)
  private String x;

  public static final String SERIALIZED_NAME_P = "p";
  @SerializedName(SERIALIZED_NAME_P)
  private Double p;

  public static final String SERIALIZED_NAME_S = "s";
  @SerializedName(SERIALIZED_NAME_S)
  private Integer s;

  public static final String SERIALIZED_NAME_C = "c";
  @SerializedName(SERIALIZED_NAME_C)
  private String c;

  public OptionTrade() {
  }

  public OptionTrade t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp in RFC-3339 format with nanosecond precision
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }


  public OptionTrade x(String x) {
    this.x = x;
    return this;
  }

   /**
   * Get x
   * @return x
  **/
  @javax.annotation.Nonnull
  public String getX() {
    return x;
  }

  public void setX(String x) {
    this.x = x;
  }


  public OptionTrade p(Double p) {
    this.p = p;
    return this;
  }

   /**
   * Trade price
   * @return p
  **/
  @javax.annotation.Nonnull
  public Double getP() {
    return p;
  }

  public void setP(Double p) {
    this.p = p;
  }


  public OptionTrade s(Integer s) {
    this.s = s;
    return this;
  }

   /**
   * Trade size
   * @return s
  **/
  @javax.annotation.Nonnull
  public Integer getS() {
    return s;
  }

  public void setS(Integer s) {
    this.s = s;
  }


  public OptionTrade c(String c) {
    this.c = c;
    return this;
  }

   /**
   * Trade condition
   * @return c
  **/
  @javax.annotation.Nonnull
  public String getC() {
    return c;
  }

  public void setC(String c) {
    this.c = c;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OptionTrade optionTrade = (OptionTrade) o;
    return Objects.equals(this.t, optionTrade.t) &&
        Objects.equals(this.x, optionTrade.x) &&
        Objects.equals(this.p, optionTrade.p) &&
        Objects.equals(this.s, optionTrade.s) &&
        Objects.equals(this.c, optionTrade.c);
  }

  @Override
  public int hashCode() {
    return Objects.hash(t, x, p, s, c);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OptionTrade {\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("    x: ").append(toIndentedString(x)).append("\n");
    sb.append("    p: ").append(toIndentedString(p)).append("\n");
    sb.append("    s: ").append(toIndentedString(s)).append("\n");
    sb.append("    c: ").append(toIndentedString(c)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("t");
    openapiFields.add("x");
    openapiFields.add("p");
    openapiFields.add("s");
    openapiFields.add("c");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("t");
    openapiRequiredFields.add("x");
    openapiRequiredFields.add("p");
    openapiRequiredFields.add("s");
    openapiRequiredFields.add("c");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!OptionTrade.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in OptionTrade is not found in the empty JSON string", OptionTrade.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!OptionTrade.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OptionTrade` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : OptionTrade.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("x").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `x` to be a primitive type in the JSON string but got `%s`", jsonObj.get("x").toString()));
      }
      if (!jsonObj.get("c").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `c` to be a primitive type in the JSON string but got `%s`", jsonObj.get("c").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!OptionTrade.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'OptionTrade' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<OptionTrade> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(OptionTrade.class));

       return (TypeAdapter<T>) new TypeAdapter<OptionTrade>() {
           @Override
           public void write(JsonWriter out, OptionTrade value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public OptionTrade read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of OptionTrade given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of OptionTrade
  * @throws IOException if the JSON string is invalid with respect to OptionTrade
  */
  public static OptionTrade fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, OptionTrade.class);
  }

 /**
  * Convert an instance of OptionTrade to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

