/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionQuote;
import net.jacobpeterson.alpaca.openapi.marketdata.model.OptionTrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * A snapshot provides the latest trade and latest quote. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class OptionSnapshot {
  public static final String SERIALIZED_NAME_LATEST_QUOTE = "latestQuote";
  @SerializedName(SERIALIZED_NAME_LATEST_QUOTE)
  private OptionQuote latestQuote;

  public static final String SERIALIZED_NAME_LATEST_TRADE = "latestTrade";
  @SerializedName(SERIALIZED_NAME_LATEST_TRADE)
  private OptionTrade latestTrade;

  public OptionSnapshot() {
  }

  public OptionSnapshot latestQuote(OptionQuote latestQuote) {
    this.latestQuote = latestQuote;
    return this;
  }

   /**
   * Get latestQuote
   * @return latestQuote
  **/
  @javax.annotation.Nullable
  public OptionQuote getLatestQuote() {
    return latestQuote;
  }

  public void setLatestQuote(OptionQuote latestQuote) {
    this.latestQuote = latestQuote;
  }


  public OptionSnapshot latestTrade(OptionTrade latestTrade) {
    this.latestTrade = latestTrade;
    return this;
  }

   /**
   * Get latestTrade
   * @return latestTrade
  **/
  @javax.annotation.Nullable
  public OptionTrade getLatestTrade() {
    return latestTrade;
  }

  public void setLatestTrade(OptionTrade latestTrade) {
    this.latestTrade = latestTrade;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OptionSnapshot optionSnapshot = (OptionSnapshot) o;
    return Objects.equals(this.latestQuote, optionSnapshot.latestQuote) &&
        Objects.equals(this.latestTrade, optionSnapshot.latestTrade);
  }

  @Override
  public int hashCode() {
    return Objects.hash(latestQuote, latestTrade);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OptionSnapshot {\n");
    sb.append("    latestQuote: ").append(toIndentedString(latestQuote)).append("\n");
    sb.append("    latestTrade: ").append(toIndentedString(latestTrade)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("latestQuote");
    openapiFields.add("latestTrade");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!OptionSnapshot.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in OptionSnapshot is not found in the empty JSON string", OptionSnapshot.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!OptionSnapshot.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OptionSnapshot` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `latestQuote`
      if (jsonObj.get("latestQuote") != null && !jsonObj.get("latestQuote").isJsonNull()) {
        OptionQuote.validateJsonElement(jsonObj.get("latestQuote"));
      }
      // validate the optional field `latestTrade`
      if (jsonObj.get("latestTrade") != null && !jsonObj.get("latestTrade").isJsonNull()) {
        OptionTrade.validateJsonElement(jsonObj.get("latestTrade"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!OptionSnapshot.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'OptionSnapshot' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<OptionSnapshot> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(OptionSnapshot.class));

       return (TypeAdapter<T>) new TypeAdapter<OptionSnapshot>() {
           @Override
           public void write(JsonWriter out, OptionSnapshot value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public OptionSnapshot read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of OptionSnapshot given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of OptionSnapshot
  * @throws IOException if the JSON string is invalid with respect to OptionSnapshot
  */
  public static OptionSnapshot fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, OptionSnapshot.class);
  }

 /**
  * Convert an instance of OptionSnapshot to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

