/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * A foreign exchange rate between two currencies at a given time
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class ForexRate {
  public static final String SERIALIZED_NAME_BP = "bp";
  @SerializedName(SERIALIZED_NAME_BP)
  private Double bp;

  public static final String SERIALIZED_NAME_MP = "mp";
  @SerializedName(SERIALIZED_NAME_MP)
  private Double mp;

  public static final String SERIALIZED_NAME_AP = "ap";
  @SerializedName(SERIALIZED_NAME_AP)
  private Double ap;

  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public ForexRate() {
  }

  public ForexRate bp(Double bp) {
    this.bp = bp;
    return this;
  }

   /**
   * The last bid price value of the currency at the end of the timeframe
   * @return bp
  **/
  @javax.annotation.Nonnull
  public Double getBp() {
    return bp;
  }

  public void setBp(Double bp) {
    this.bp = bp;
  }


  public ForexRate mp(Double mp) {
    this.mp = mp;
    return this;
  }

   /**
   * The last mid price value of the currency at the end of the timeframe
   * @return mp
  **/
  @javax.annotation.Nonnull
  public Double getMp() {
    return mp;
  }

  public void setMp(Double mp) {
    this.mp = mp;
  }


  public ForexRate ap(Double ap) {
    this.ap = ap;
    return this;
  }

   /**
   * The last ask price value of the currency at the end of the timeframe
   * @return ap
  **/
  @javax.annotation.Nonnull
  public Double getAp() {
    return ap;
  }

  public void setAp(Double ap) {
    this.ap = ap;
  }


  public ForexRate t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp of the rate
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ForexRate forexRate = (ForexRate) o;
    return Objects.equals(this.bp, forexRate.bp) &&
        Objects.equals(this.mp, forexRate.mp) &&
        Objects.equals(this.ap, forexRate.ap) &&
        Objects.equals(this.t, forexRate.t);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bp, mp, ap, t);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ForexRate {\n");
    sb.append("    bp: ").append(toIndentedString(bp)).append("\n");
    sb.append("    mp: ").append(toIndentedString(mp)).append("\n");
    sb.append("    ap: ").append(toIndentedString(ap)).append("\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("bp");
    openapiFields.add("mp");
    openapiFields.add("ap");
    openapiFields.add("t");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("bp");
    openapiRequiredFields.add("mp");
    openapiRequiredFields.add("ap");
    openapiRequiredFields.add("t");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!ForexRate.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ForexRate is not found in the empty JSON string", ForexRate.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!ForexRate.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ForexRate` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ForexRate.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ForexRate.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ForexRate' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ForexRate> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ForexRate.class));

       return (TypeAdapter<T>) new TypeAdapter<ForexRate>() {
           @Override
           public void write(JsonWriter out, ForexRate value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ForexRate read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ForexRate given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ForexRate
  * @throws IOException if the JSON string is invalid with respect to ForexRate
  */
  public static ForexRate fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ForexRate.class);
  }

 /**
  * Convert an instance of ForexRate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

