/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * A crypto trade
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CryptoTrade {
  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public static final String SERIALIZED_NAME_P = "p";
  @SerializedName(SERIALIZED_NAME_P)
  private Double p;

  public static final String SERIALIZED_NAME_S = "s";
  @SerializedName(SERIALIZED_NAME_S)
  private Double s;

  public static final String SERIALIZED_NAME_I = "i";
  @SerializedName(SERIALIZED_NAME_I)
  private Long i;

  public static final String SERIALIZED_NAME_TKS = "tks";
  @SerializedName(SERIALIZED_NAME_TKS)
  private String tks;

  public CryptoTrade() {
  }

  public CryptoTrade t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp in RFC-3339 format with nanosecond precision
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }


  public CryptoTrade p(Double p) {
    this.p = p;
    return this;
  }

   /**
   * Trade price
   * @return p
  **/
  @javax.annotation.Nonnull
  public Double getP() {
    return p;
  }

  public void setP(Double p) {
    this.p = p;
  }


  public CryptoTrade s(Double s) {
    this.s = s;
    return this;
  }

   /**
   * Trade size
   * @return s
  **/
  @javax.annotation.Nonnull
  public Double getS() {
    return s;
  }

  public void setS(Double s) {
    this.s = s;
  }


  public CryptoTrade i(Long i) {
    this.i = i;
    return this;
  }

   /**
   * Trade ID
   * @return i
  **/
  @javax.annotation.Nonnull
  public Long getI() {
    return i;
  }

  public void setI(Long i) {
    this.i = i;
  }


  public CryptoTrade tks(String tks) {
    this.tks = tks;
    return this;
  }

   /**
   * Taker side: B for buyer, S for seller 
   * @return tks
  **/
  @javax.annotation.Nonnull
  public String getTks() {
    return tks;
  }

  public void setTks(String tks) {
    this.tks = tks;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoTrade cryptoTrade = (CryptoTrade) o;
    return Objects.equals(this.t, cryptoTrade.t) &&
        Objects.equals(this.p, cryptoTrade.p) &&
        Objects.equals(this.s, cryptoTrade.s) &&
        Objects.equals(this.i, cryptoTrade.i) &&
        Objects.equals(this.tks, cryptoTrade.tks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(t, p, s, i, tks);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoTrade {\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("    p: ").append(toIndentedString(p)).append("\n");
    sb.append("    s: ").append(toIndentedString(s)).append("\n");
    sb.append("    i: ").append(toIndentedString(i)).append("\n");
    sb.append("    tks: ").append(toIndentedString(tks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("t");
    openapiFields.add("p");
    openapiFields.add("s");
    openapiFields.add("i");
    openapiFields.add("tks");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("t");
    openapiRequiredFields.add("p");
    openapiRequiredFields.add("s");
    openapiRequiredFields.add("i");
    openapiRequiredFields.add("tks");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CryptoTrade.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CryptoTrade is not found in the empty JSON string", CryptoTrade.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CryptoTrade.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CryptoTrade` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CryptoTrade.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("tks").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `tks` to be a primitive type in the JSON string but got `%s`", jsonObj.get("tks").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CryptoTrade.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CryptoTrade' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CryptoTrade> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CryptoTrade.class));

       return (TypeAdapter<T>) new TypeAdapter<CryptoTrade>() {
           @Override
           public void write(JsonWriter out, CryptoTrade value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CryptoTrade read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CryptoTrade given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CryptoTrade
  * @throws IOException if the JSON string is invalid with respect to CryptoTrade
  */
  public static CryptoTrade fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CryptoTrade.class);
  }

 /**
  * Convert an instance of CryptoTrade to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

