/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * The best bid and ask information for a given security. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CryptoQuote {
  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public static final String SERIALIZED_NAME_BP = "bp";
  @SerializedName(SERIALIZED_NAME_BP)
  private Double bp;

  public static final String SERIALIZED_NAME_BS = "bs";
  @SerializedName(SERIALIZED_NAME_BS)
  private Double bs;

  public static final String SERIALIZED_NAME_AP = "ap";
  @SerializedName(SERIALIZED_NAME_AP)
  private Double ap;

  public static final String SERIALIZED_NAME_AS = "as";
  @SerializedName(SERIALIZED_NAME_AS)
  private Double as;

  public CryptoQuote() {
  }

  public CryptoQuote t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp in RFC-3339 format with nanosecond precision
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }


  public CryptoQuote bp(Double bp) {
    this.bp = bp;
    return this;
  }

   /**
   * Bid price
   * @return bp
  **/
  @javax.annotation.Nonnull
  public Double getBp() {
    return bp;
  }

  public void setBp(Double bp) {
    this.bp = bp;
  }


  public CryptoQuote bs(Double bs) {
    this.bs = bs;
    return this;
  }

   /**
   * Bid size
   * @return bs
  **/
  @javax.annotation.Nonnull
  public Double getBs() {
    return bs;
  }

  public void setBs(Double bs) {
    this.bs = bs;
  }


  public CryptoQuote ap(Double ap) {
    this.ap = ap;
    return this;
  }

   /**
   * Ask price
   * @return ap
  **/
  @javax.annotation.Nonnull
  public Double getAp() {
    return ap;
  }

  public void setAp(Double ap) {
    this.ap = ap;
  }


  public CryptoQuote as(Double as) {
    this.as = as;
    return this;
  }

   /**
   * Ask size
   * @return as
  **/
  @javax.annotation.Nonnull
  public Double getAs() {
    return as;
  }

  public void setAs(Double as) {
    this.as = as;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoQuote cryptoQuote = (CryptoQuote) o;
    return Objects.equals(this.t, cryptoQuote.t) &&
        Objects.equals(this.bp, cryptoQuote.bp) &&
        Objects.equals(this.bs, cryptoQuote.bs) &&
        Objects.equals(this.ap, cryptoQuote.ap) &&
        Objects.equals(this.as, cryptoQuote.as);
  }

  @Override
  public int hashCode() {
    return Objects.hash(t, bp, bs, ap, as);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoQuote {\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("    bp: ").append(toIndentedString(bp)).append("\n");
    sb.append("    bs: ").append(toIndentedString(bs)).append("\n");
    sb.append("    ap: ").append(toIndentedString(ap)).append("\n");
    sb.append("    as: ").append(toIndentedString(as)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("t");
    openapiFields.add("bp");
    openapiFields.add("bs");
    openapiFields.add("ap");
    openapiFields.add("as");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("t");
    openapiRequiredFields.add("bp");
    openapiRequiredFields.add("bs");
    openapiRequiredFields.add("ap");
    openapiRequiredFields.add("as");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CryptoQuote.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CryptoQuote is not found in the empty JSON string", CryptoQuote.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CryptoQuote.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CryptoQuote` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CryptoQuote.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CryptoQuote.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CryptoQuote' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CryptoQuote> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CryptoQuote.class));

       return (TypeAdapter<T>) new TypeAdapter<CryptoQuote>() {
           @Override
           public void write(JsonWriter out, CryptoQuote value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CryptoQuote read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CryptoQuote given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CryptoQuote
  * @throws IOException if the JSON string is invalid with respect to CryptoQuote
  */
  public static CryptoQuote fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CryptoQuote.class);
  }

 /**
  * Convert an instance of CryptoQuote to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

