/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * A single entry in a crypto orderbook 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CryptoOrderbookEntry {
  public static final String SERIALIZED_NAME_P = "p";
  @SerializedName(SERIALIZED_NAME_P)
  private Double p;

  public static final String SERIALIZED_NAME_S = "s";
  @SerializedName(SERIALIZED_NAME_S)
  private Double s;

  public CryptoOrderbookEntry() {
  }

  public CryptoOrderbookEntry p(Double p) {
    this.p = p;
    return this;
  }

   /**
   * Price
   * @return p
  **/
  @javax.annotation.Nonnull
  public Double getP() {
    return p;
  }

  public void setP(Double p) {
    this.p = p;
  }


  public CryptoOrderbookEntry s(Double s) {
    this.s = s;
    return this;
  }

   /**
   * Size
   * @return s
  **/
  @javax.annotation.Nonnull
  public Double getS() {
    return s;
  }

  public void setS(Double s) {
    this.s = s;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoOrderbookEntry cryptoOrderbookEntry = (CryptoOrderbookEntry) o;
    return Objects.equals(this.p, cryptoOrderbookEntry.p) &&
        Objects.equals(this.s, cryptoOrderbookEntry.s);
  }

  @Override
  public int hashCode() {
    return Objects.hash(p, s);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoOrderbookEntry {\n");
    sb.append("    p: ").append(toIndentedString(p)).append("\n");
    sb.append("    s: ").append(toIndentedString(s)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("p");
    openapiFields.add("s");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("p");
    openapiRequiredFields.add("s");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CryptoOrderbookEntry.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CryptoOrderbookEntry is not found in the empty JSON string", CryptoOrderbookEntry.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CryptoOrderbookEntry.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CryptoOrderbookEntry` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CryptoOrderbookEntry.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CryptoOrderbookEntry.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CryptoOrderbookEntry' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CryptoOrderbookEntry> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CryptoOrderbookEntry.class));

       return (TypeAdapter<T>) new TypeAdapter<CryptoOrderbookEntry>() {
           @Override
           public void write(JsonWriter out, CryptoOrderbookEntry value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CryptoOrderbookEntry read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CryptoOrderbookEntry given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CryptoOrderbookEntry
  * @throws IOException if the JSON string is invalid with respect to CryptoOrderbookEntry
  */
  public static CryptoOrderbookEntry fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CryptoOrderbookEntry.class);
  }

 /**
  * Convert an instance of CryptoOrderbookEntry to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

