/*
 * Alpaca Market Data API
 * Access real-time and historical market data for US equities, options (BETA), crypto, and foreign exchange data through the Alpaca REST and WebSocket APIs. There are APIs for Stock Pricing, Option Pricing, Crypto Pricing, Forex, Logos, Corporate Actions and News. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.marketdata.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.marketdata.model.CryptoOrderbookEntry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.marketdata.JSON;

/**
 * Snapshot of the orderbook. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:48.103703-08:00[America/Los_Angeles]")
public class CryptoOrderbook {
  public static final String SERIALIZED_NAME_T = "t";
  @SerializedName(SERIALIZED_NAME_T)
  private OffsetDateTime t;

  public static final String SERIALIZED_NAME_B = "b";
  @SerializedName(SERIALIZED_NAME_B)
  private List<CryptoOrderbookEntry> b = new ArrayList<>();

  public static final String SERIALIZED_NAME_A = "a";
  @SerializedName(SERIALIZED_NAME_A)
  private List<CryptoOrderbookEntry> a = new ArrayList<>();

  public CryptoOrderbook() {
  }

  public CryptoOrderbook t(OffsetDateTime t) {
    this.t = t;
    return this;
  }

   /**
   * Timestamp in RFC-3339 format with nanosecond precision
   * @return t
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getT() {
    return t;
  }

  public void setT(OffsetDateTime t) {
    this.t = t;
  }


  public CryptoOrderbook b(List<CryptoOrderbookEntry> b) {
    this.b = b;
    return this;
  }

  public CryptoOrderbook addBItem(CryptoOrderbookEntry bItem) {
    if (this.b == null) {
      this.b = new ArrayList<>();
    }
    this.b.add(bItem);
    return this;
  }

   /**
   * Get b
   * @return b
  **/
  @javax.annotation.Nonnull
  public List<CryptoOrderbookEntry> getB() {
    return b;
  }

  public void setB(List<CryptoOrderbookEntry> b) {
    this.b = b;
  }


  public CryptoOrderbook a(List<CryptoOrderbookEntry> a) {
    this.a = a;
    return this;
  }

  public CryptoOrderbook addAItem(CryptoOrderbookEntry aItem) {
    if (this.a == null) {
      this.a = new ArrayList<>();
    }
    this.a.add(aItem);
    return this;
  }

   /**
   * Get a
   * @return a
  **/
  @javax.annotation.Nonnull
  public List<CryptoOrderbookEntry> getA() {
    return a;
  }

  public void setA(List<CryptoOrderbookEntry> a) {
    this.a = a;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoOrderbook cryptoOrderbook = (CryptoOrderbook) o;
    return Objects.equals(this.t, cryptoOrderbook.t) &&
        Objects.equals(this.b, cryptoOrderbook.b) &&
        Objects.equals(this.a, cryptoOrderbook.a);
  }

  @Override
  public int hashCode() {
    return Objects.hash(t, b, a);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoOrderbook {\n");
    sb.append("    t: ").append(toIndentedString(t)).append("\n");
    sb.append("    b: ").append(toIndentedString(b)).append("\n");
    sb.append("    a: ").append(toIndentedString(a)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("t");
    openapiFields.add("b");
    openapiFields.add("a");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("t");
    openapiRequiredFields.add("b");
    openapiRequiredFields.add("a");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CryptoOrderbook.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CryptoOrderbook is not found in the empty JSON string", CryptoOrderbook.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CryptoOrderbook.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CryptoOrderbook` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CryptoOrderbook.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the json data is an array
      if (!jsonObj.get("b").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `b` to be an array in the JSON string but got `%s`", jsonObj.get("b").toString()));
      }

      JsonArray jsonArrayb = jsonObj.getAsJsonArray("b");
      // validate the required field `b` (array)
      for (int i = 0; i < jsonArrayb.size(); i++) {
        CryptoOrderbookEntry.validateJsonElement(jsonArrayb.get(i));
      };
      // ensure the json data is an array
      if (!jsonObj.get("a").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `a` to be an array in the JSON string but got `%s`", jsonObj.get("a").toString()));
      }

      JsonArray jsonArraya = jsonObj.getAsJsonArray("a");
      // validate the required field `a` (array)
      for (int i = 0; i < jsonArraya.size(); i++) {
        CryptoOrderbookEntry.validateJsonElement(jsonArraya.get(i));
      };
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CryptoOrderbook.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CryptoOrderbook' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CryptoOrderbook> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CryptoOrderbook.class));

       return (TypeAdapter<T>) new TypeAdapter<CryptoOrderbook>() {
           @Override
           public void write(JsonWriter out, CryptoOrderbook value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CryptoOrderbook read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CryptoOrderbook given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CryptoOrderbook
  * @throws IOException if the JSON string is invalid with respect to CryptoOrderbook
  */
  public static CryptoOrderbook fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CryptoOrderbook.class);
  }

 /**
  * Convert an instance of CryptoOrderbook to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

